/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.format;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import jd.util.Quicksort;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.object.XMutableNodeSet;
import jd.xml.xpath.object.XNodeSet;
import jd.xml.xpath.object.XNodeSetFactory;
import jd.xml.xpath.object.XString;
import jd.xml.xslt.AttributeValue;
import jd.xml.xslt.XsltContext;
import jd.xml.xslt.XsltException;

public class Sort {
    private Sort next_;
    private Expression select_;
    private AttributeValue lang_;
    private AttributeValue dataType_;
    private AttributeValue order_;
    private AttributeValue caseOrder_;

    public Sort(Expression expression, AttributeValue attributeValue, AttributeValue attributeValue2, AttributeValue attributeValue3, AttributeValue attributeValue4) {
        this.select_ = expression;
        this.lang_ = attributeValue;
        this.dataType_ = attributeValue2;
        this.order_ = attributeValue3;
        this.caseOrder_ = attributeValue4;
    }

    public void addNext(Sort sort) {
        if (this.next_ == null) {
            this.next_ = sort;
        } else {
            this.next_.addNext(sort);
        }
    }

    public Sort getNext() {
        return this.next_;
    }

    public Expression getSelect() {
        return this.select_;
    }

    public AttributeValue getLang() {
        return this.lang_;
    }

    public AttributeValue getDataType() {
        return this.dataType_;
    }

    public AttributeValue getOrder() {
        return this.order_;
    }

    public AttributeValue getCaseOrder() {
        return this.caseOrder_;
    }

    public synchronized XNodeSet sort(XsltContext xsltContext, XNodeSet xNodeSet) {
        Object object;
        int n = xNodeSet.size();
        if (n <= 1) {
            return xNodeSet;
        }
        Entry[] entryArray = new Entry[n];
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            entryArray[n2] = new Entry();
            object = entryArray[n2];
            ((Entry)object).node = xNodeSet.getNode(n2);
            ((Entry)object).position = n3++;
            ++n2;
        }
        this.sort(xsltContext, entryArray, null);
        object = XNodeSetFactory.create(0, n);
        int n4 = 0;
        while (n4 < n) {
            ((XMutableNodeSet)object).addNode(entryArray[n4].node);
            ++n4;
        }
        return object;
    }

    private void sort(XsltContext xsltContext, Entry[] entryArray, Comparator comparator) {
        Comparator comparator2 = this.createComparator(xsltContext);
        int n = entryArray.length;
        boolean bl = false;
        XPathNode xPathNode = xsltContext.getCurrentNode();
        xsltContext.startNewState();
        xsltContext.setSize(n);
        if (comparator == null) {
            int n2 = 0;
            while (n2 < n) {
                Entry entry = entryArray[n2];
                xsltContext.setNode(entry.node);
                xsltContext.setCurrentNode(entry.node);
                xsltContext.setPosition(entry.position);
                comparator2.setKey(xsltContext, this.select_, entry);
                ++n2;
            }
            bl = true;
        } else {
            int n3 = 0;
            boolean bl2 = entryArray[0].hasEqualEntry;
            Entry entry = entryArray[0];
            int n4 = 0;
            while (n4 < n) {
                Entry entry2 = entryArray[n4];
                if (!entry2.hasEqualEntry) {
                    ++n3;
                } else if (entry2.hasEqualEntry != bl2) {
                    ++n3;
                } else if (entry2.hasEqualEntry && !comparator.haveEqualKeys(entry2, entry)) {
                    ++n3;
                }
                entry2.order += n3;
                entry = entry2;
                bl2 = entry2.hasEqualEntry;
                if (entry2.hasEqualEntry) {
                    bl = true;
                }
                ++n4;
            }
            if (bl) {
                int n5 = 0;
                while (n5 < n) {
                    Entry entry3 = entryArray[n5];
                    if (entry3.hasEqualEntry) {
                        xsltContext.setNode(entry3.node);
                        xsltContext.setPosition(entry3.position);
                        comparator2.setKey(xsltContext, this.select_, entry3);
                        entry3.hasEqualEntry = false;
                    }
                    ++n5;
                }
            }
        }
        xsltContext.restoreState();
        xsltContext.setCurrentNode(xPathNode);
        if (bl) {
            Quicksort.sort(comparator2, entryArray);
            if (this.next_ != null) {
                this.next_.sort(xsltContext, entryArray, comparator2);
            }
        }
    }

    private Comparator createComparator(XsltContext xsltContext) {
        String string = this.evaluate(xsltContext, this.order_);
        boolean bl = Sort.getBoolean(string, "ascending", "descending", true);
        String string2 = this.evaluate(xsltContext, this.dataType_);
        if (string2 == null || string2.equals("text")) {
            String string3 = this.evaluate(xsltContext, this.lang_);
            String string4 = this.evaluate(xsltContext, this.caseOrder_);
            return new TextComparator(string3, string4, bl);
        }
        if (string2.equals("number")) {
            return new NumberComparator(bl);
        }
        throw new XsltException("cannot handle sort data-type '" + string2 + "'");
    }

    private String evaluate(XsltContext xsltContext, AttributeValue attributeValue) {
        return attributeValue != null ? attributeValue.evaluate(xsltContext) : null;
    }

    private static boolean getBoolean(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            return bl;
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.equals(string3)) {
            return false;
        }
        throw new XsltException("illegal sort value '" + string + "'");
    }

    private static class NumberComparator
    extends Comparator {
        private boolean ascending_;

        public NumberComparator(boolean bl) {
            this.ascending_ = bl;
        }

        public void setKey(Entry entry, double d) {
            entry.numberKey = d;
            entry.isNaN = Double.isNaN(d);
        }

        public void setKey(XsltContext xsltContext, Expression expression, Entry entry) {
            this.setKey(entry, expression == null ? XString.toNumberValue(entry.node.getValue()) : expression.toNumberValue(xsltContext));
        }

        public boolean haveEqualKeys(Entry entry, Entry entry2) {
            return entry.numberKey == entry2.numberKey;
        }

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            int n = entry.order - entry2.order;
            if (n == 0) {
                double d = entry.isNaN ? (entry2.isNaN ? 0.0 : -1.0) : (entry2.isNaN ? 1.0 : entry.numberKey - entry2.numberKey);
                if (!this.ascending_) {
                    d = -d;
                }
                if (d < 0.0) {
                    n = -1;
                } else if (d > 0.0) {
                    n = 1;
                } else {
                    entry2.hasEqualEntry = true;
                    entry.hasEqualEntry = true;
                    n = entry.position - entry2.position;
                }
            }
            return n;
        }
    }

    private static class TextComparator
    extends Comparator {
        private boolean ascending_;
        private boolean upperFirst_;
        private Collator collator_;

        public TextComparator(String string, String string2, boolean bl) {
            int n;
            this.ascending_ = bl;
            Locale locale = string == null ? Locale.getDefault() : ((n = string.indexOf(45)) == -1 ? new Locale(string, "", "") : new Locale(string.substring(0, n), string.substring(n + 1), ""));
            this.collator_ = Collator.getInstance(locale);
            this.upperFirst_ = Sort.getBoolean(string2, "upper-first", "lower-first", false);
        }

        public void setKey(Entry entry, String string) {
            entry.stringKey = string;
            entry.textKey = this.collator_.getCollationKey(string);
            if (this.upperFirst_) {
                entry.lowerCaseKey = entry.stringKey.toLowerCase();
            }
        }

        public void setKey(XsltContext xsltContext, Expression expression, Entry entry) {
            this.setKey(entry, expression == null ? entry.node.getValue() : expression.toStringValue(xsltContext));
        }

        public boolean haveEqualKeys(Entry entry, Entry entry2) {
            return entry.stringKey.equals(entry2.stringKey);
        }

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            int n = entry.order - entry2.order;
            if (n == 0) {
                n = entry.textKey.compareTo(entry2.textKey);
                if (this.upperFirst_ && entry.lowerCaseKey.equals(entry2.lowerCaseKey)) {
                    n = -n;
                }
                if (n == 0) {
                    entry2.hasEqualEntry = true;
                    entry.hasEqualEntry = true;
                    n = entry.position - entry2.position;
                } else if (!this.ascending_) {
                    n = -n;
                }
            }
            return n;
        }
    }

    private static abstract class Comparator
    implements jd.util.Comparator {
        private Comparator() {
        }

        public abstract void setKey(XsltContext var1, Expression var2, Entry var3);

        public abstract boolean haveEqualKeys(Entry var1, Entry var2);
    }

    private static class Entry {
        XPathNode node;
        String stringKey;
        CollationKey textKey;
        String lowerCaseKey;
        double numberKey;
        boolean isNaN;
        int position;
        int order;
        boolean hasEqualEntry;

        private Entry() {
        }
    }
}

