/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.Hashtable;
import java.util.Vector;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.ExpressionVisitor;
import jd.xml.xpath.expr.visitor.ExprScreener;
import jd.xml.xslt.format.Sort;
import jd.xml.xslt.parser.XsltParseContext;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.template.TemplateRule;
import jd.xml.xslt.template.TemplateRuleList;
import jd.xml.xslt.template.TemplateScreener;
import jd.xml.xslt.template.Variable;

class VariableSorter {
    private XsltParseContext context_;
    private Variable[] variables_;
    private Variable[] result_;
    private Entry screenedEntry_;
    private Entry[] entries_;
    private Hashtable nameMap_;
    private int firstUnClassified_;

    VariableSorter() {
    }

    public synchronized void sort(XsltParseContext xsltParseContext, Variable[] variableArray) throws XsltParseException {
        this.firstUnClassified_ = variableArray.length;
        int n = this.firstUnClassified_;
        if (n < 2) {
            this.result_ = variableArray;
            return;
        }
        this.context_ = xsltParseContext;
        this.variables_ = variableArray;
        this.init();
        this.screen();
        this.sort();
    }

    public Variable[] getSortedVariables() {
        return this.result_;
    }

    public int firstUnClassifiedGlobalVar() {
        return this.firstUnClassified_;
    }

    private void init() {
        int n = this.variables_.length;
        this.entries_ = new Entry[n];
        this.nameMap_ = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            Entry entry = this.entries_[n2] = new Entry();
            entry.variable = this.variables_[n2];
            this.nameMap_.put(this.variables_[n2].getVariableName(), entry);
            ++n2;
        }
    }

    private void screen() {
        VarTemplateScreener varTemplateScreener = new VarTemplateScreener(new VarExprScreener());
        int n = 0;
        while (n < this.variables_.length) {
            this.screenedEntry_ = this.entries_[n];
            varTemplateScreener.visit(this.variables_[n]);
            ++n;
        }
    }

    private void sort() throws XsltParseException {
        int n = this.variables_.length;
        this.result_ = new Variable[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = 0;
            while (n4 < n) {
                Entry entry = this.entries_[n4];
                if (entry.variable != null && entry.dependsOn == null && entry.dependeciesKnown) {
                    this.result_[n2++] = this.removeDependency(entry);
                }
                ++n4;
            }
            if (n2 != n3) continue;
            int n5 = 0;
            while (n5 < n) {
                Entry entry = this.entries_[n5];
                if (entry.variable != null && !entry.dependeciesKnown) {
                    this.firstUnClassified_ = Math.min(n2, this.firstUnClassified_);
                    this.result_[n2++] = this.removeDependency(entry);
                }
                ++n5;
            }
            if (n2 != n3) continue;
            this.reportCircularDependency();
        }
    }

    private Variable removeDependency(Entry entry) {
        Object object;
        int n = 0;
        while (n < this.entries_.length) {
            object = this.entries_[n];
            if (((Entry)object).dependsOn != null) {
                while (((Entry)object).dependsOn.removeElement(entry)) {
                }
                if (((Entry)object).dependsOn.size() == 0) {
                    ((Entry)object).dependsOn = null;
                }
            }
            ++n;
        }
        object = entry.variable;
        entry.variable = null;
        return object;
    }

    private void reportCircularDependency() throws XsltParseException {
        int n = 0;
        while (n < this.entries_.length) {
            Entry entry = this.entries_[n];
            if (entry.variable != null) {
                String string = entry.variable.getVariableName().getName();
                String string2 = entry.variable.isParameter() ? "parameter" : "variable";
                String string3 = string2 + " '" + string + "' has a circular dependency on other variables";
                throw new XsltParseException(string3, this.context_.getDocumentBaseUri(), null);
            }
            ++n;
        }
    }

    private class VarExprScreener
    extends ExprScreener {
        private VarExprScreener() {
        }

        public void variableReference(Expression expression, VariableName variableName) {
            Entry entry = (Entry)VariableSorter.this.nameMap_.get(variableName);
            if (entry != null) {
                if (((VariableSorter)VariableSorter.this).screenedEntry_.dependsOn == null) {
                    ((VariableSorter)VariableSorter.this).screenedEntry_.dependsOn = new Vector();
                }
                ((VariableSorter)VariableSorter.this).screenedEntry_.dependsOn.addElement(entry);
            }
        }
    }

    private class VarTemplateScreener
    extends TemplateScreener {
        public VarTemplateScreener(ExpressionVisitor expressionVisitor) {
            super(expressionVisitor);
        }

        public void applyImports(TemplateRuleList templateRuleList, Variable[] variableArray, int n) {
            ((VariableSorter)VariableSorter.this).screenedEntry_.dependeciesKnown = false;
        }

        public void applyTemplates(TemplateRuleList templateRuleList, Expression expression, Sort sort, Variable[] variableArray) {
            ((VariableSorter)VariableSorter.this).screenedEntry_.dependeciesKnown = false;
        }

        public void callTemplate(TemplateRule templateRule, Variable[] variableArray, int n, boolean bl) {
            ((VariableSorter)VariableSorter.this).screenedEntry_.dependeciesKnown = false;
        }
    }

    private static class Entry {
        Variable variable;
        Vector dependsOn;
        boolean dependeciesKnown = true;

        private Entry() {
        }
    }
}

