/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import java.util.Vector;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.ResultBuilder;

public class ResultTreeRecorder
extends ResultBuilder {
    private Item firstItem_;
    private Item lastItem_;
    private Vector subRecorders_;
    private String content_;
    private int textLength_;
    private OutputFormat outputFormat_;

    public ResultTreeRecorder() {
        super(null);
    }

    private ResultTreeRecorder(String string) {
        super(string);
    }

    public void startDocument(OutputFormat outputFormat) {
        this.outputFormat_ = outputFormat;
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
        this.addItem(new ElementStart(string2, string, namespaceContext, bl));
    }

    public void endElement() {
        this.addItem(new ElementEnd());
    }

    public void addAttribute(String string, String string2, String string3, String string4) {
        this.addItem(new Attribute(string, string3, string2, string4));
    }

    public void addNamespace(String string, String string2, boolean bl) {
        this.addItem(new Ns(string, string2, bl));
    }

    public String getNamespacePrefix(String string) {
        return null;
    }

    public void addComment(String string) {
        this.addItem(new Comment(string));
    }

    public void addProcessingInstruction(String string, String string2) {
        this.addItem(new Pi(string, string2));
    }

    public void addText(String string) {
        this.textLength_ += string.length();
        this.addItem(new Text(string, false));
    }

    public void addTextUnescaped(String string) {
        this.textLength_ += string.length();
        this.addItem(new Text(string, true));
    }

    private void addItem(Item item) {
        if (this.firstItem_ == null) {
            this.firstItem_ = this.lastItem_ = item;
        } else {
            this.lastItem_.next_ = item;
            this.lastItem_ = item;
        }
    }

    public boolean isEmpty() {
        return this.firstItem_ == null;
    }

    public String getStringContent() {
        if (this.content_ == null) {
            StringBuffer stringBuffer = new StringBuffer(this.textLength_);
            Item item = this.firstItem_;
            while (item != null) {
                item.getStringContent(stringBuffer);
                item = item.next_;
            }
            this.content_ = stringBuffer.toString();
        }
        return this.content_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(ResultBuilder resultBuilder) {
        Item item = this.firstItem_;
        while (item != null) {
            item.writeTo(resultBuilder);
            item = item.next_;
        }
        if (this.subRecorders_ != null) {
            int n = this.subRecorders_.size();
            int n2 = 0;
            while (n2 < n) {
                Object var8_7;
                ResultTreeRecorder resultTreeRecorder = (ResultTreeRecorder)this.subRecorders_.elementAt(n2);
                ResultBuilder resultBuilder2 = resultBuilder.getSubResultBuilder(resultTreeRecorder.getUri(), resultTreeRecorder.outputFormat_);
                try {
                    resultBuilder2.startDocument(resultTreeRecorder.outputFormat_);
                    resultTreeRecorder.writeTo(resultBuilder2);
                    resultBuilder2.endDocument();
                    var8_7 = null;
                    resultBuilder2.cleanup();
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    resultBuilder2.cleanup();
                    throw throwable;
                }
                ++n2;
            }
        }
    }

    public ResultBuilder getSubResultBuilder(String string, OutputFormat outputFormat) {
        ResultTreeRecorder resultTreeRecorder = new ResultTreeRecorder(string);
        if (this.subRecorders_ == null) {
            this.subRecorders_ = new Vector();
        }
        this.subRecorders_.addElement(resultTreeRecorder);
        return resultTreeRecorder;
    }

    private static class Text
    extends Item {
        private String value_;
        private boolean disableOutputEscaping_;

        public Text(String string, boolean bl) {
            this.value_ = string;
            this.disableOutputEscaping_ = bl;
        }

        public void writeTo(ResultBuilder resultBuilder) {
            if (this.disableOutputEscaping_) {
                resultBuilder.addTextUnescaped(this.value_);
            } else {
                resultBuilder.addText(this.value_);
            }
        }

        public void getStringContent(StringBuffer stringBuffer) {
            stringBuffer.append(this.value_);
        }
    }

    private static class Pi
    extends Item {
        private String name_;
        private String value_;

        public Pi(String string, String string2) {
            this.name_ = string;
            this.value_ = string2;
        }

        public void writeTo(ResultBuilder resultBuilder) {
            resultBuilder.addProcessingInstruction(this.name_, this.value_);
        }
    }

    private static class Comment
    extends Item {
        private String value_;

        public Comment(String string) {
            this.value_ = string;
        }

        public void writeTo(ResultBuilder resultBuilder) {
            resultBuilder.addComment(this.value_);
        }
    }

    private static class Ns
    extends Item {
        private String prefix_;
        private String uri_;
        private boolean test_;

        public Ns(String string, String string2, boolean bl) {
            this.prefix_ = string;
            this.uri_ = string2;
            this.test_ = bl;
        }

        public void writeTo(ResultBuilder resultBuilder) {
            resultBuilder.addNamespace(this.prefix_, this.uri_, this.test_);
        }
    }

    private static class Attribute
    extends Item {
        private String name_;
        private String uri_;
        private String prefix_;
        private String value_;

        public Attribute(String string, String string2, String string3, String string4) {
            this.name_ = string;
            this.value_ = string4;
            this.uri_ = string2;
            this.prefix_ = string3;
        }

        public void writeTo(ResultBuilder resultBuilder) {
            resultBuilder.addAttribute(this.name_, this.prefix_, this.uri_, this.value_);
        }
    }

    private static class ElementEnd
    extends Item {
        private ElementEnd() {
        }

        public void writeTo(ResultBuilder resultBuilder) {
            resultBuilder.endElement();
        }
    }

    private static class ElementStart
    extends Item {
        private String name_;
        private NamespaceContext namespaceContext_;
        private String namespaceUri_;
        private boolean isCDataSectionElement_;

        public ElementStart(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
            this.name_ = string;
            this.namespaceUri_ = string2;
            this.namespaceContext_ = namespaceContext;
            this.isCDataSectionElement_ = bl;
        }

        public void writeTo(ResultBuilder resultBuilder) {
            resultBuilder.startElement(this.namespaceUri_, this.name_, this.namespaceContext_, this.isCDataSectionElement_);
        }
    }

    private static abstract class Item {
        private Item next_;

        private Item() {
        }

        public abstract void writeTo(ResultBuilder var1);

        public void getStringContent(StringBuffer stringBuffer) {
        }
    }
}

