/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server.runner;

import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.server.runner.XMLConstants;
import org.apache.cactus.util.JUnitVersionHelper;
import org.apache.cactus.util.StringUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class XMLFormatter
implements XMLConstants,
TestListener {
    static Factory ajc$JPF = new Factory("XMLFormatter.java", class$org$apache$cactus$server$runner$XMLFormatter == null ? (class$org$apache$cactus$server$runner$XMLFormatter = XMLFormatter.class$("org.apache.cactus.server.runner.XMLFormatter")) : class$org$apache$cactus$server$runner$XMLFormatter);
    private static JoinPoint.StaticPart setXslFileName$ajcjp1 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setXslFileName-org.apache.cactus.server.runner.XMLFormatter-java.lang.String:-theXslFileName:--void-"), 117, 5);
    private static JoinPoint.StaticPart setSuiteClassName$ajcjp2 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setSuiteClassName-org.apache.cactus.server.runner.XMLFormatter-java.lang.String:-theSuiteClassName:--void-"), 135, 5);
    private static JoinPoint.StaticPart setTotalDuration$ajcjp3 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-setTotalDuration-org.apache.cactus.server.runner.XMLFormatter-long:-theDuration:--void-"), 165, 5);
    private static JoinPoint.StaticPart toXML$ajcjp4 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-toXML-org.apache.cactus.server.runner.XMLFormatter-junit.framework.TestResult:-theResult:--java.lang.String-"), 176, 5);
    private static JoinPoint.StaticPart startTest$ajcjp5 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-startTest-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 209, 5);
    private static JoinPoint.StaticPart addError$ajcjp6 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-addError-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:java.lang.Throwable:-theTest:theThrowable:--void-"), 221, 5);
    private static JoinPoint.StaticPart addFailure$ajcjp7 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-addFailure-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:junit.framework.AssertionFailedError:-theTest:theError:--void-"), 243, 5);
    private static JoinPoint.StaticPart endTest$ajcjp8 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-endTest-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 264, 5);
    private static JoinPoint.StaticPart replace$ajcjp9 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("9-replace-org.apache.cactus.server.runner.XMLFormatter-java.lang.String:char:java.lang.String:-theBaseString:theChar:theNewString:--java.lang.String-"), 313, 5);
    private String xslFileName;
    private String suiteClassName;
    private long totalDuration;
    private long currentTestStartTime;
    private StringBuffer currentTestCaseResults = new StringBuffer();
    private String currentTestFailure;
    static Class class$org$apache$cactus$server$runner$XMLFormatter;

    public void setXslFileName(String theXslFileName) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setXslFileName$ajcjp1, (Object)this, (Object)this, (Object[])new Object[]{theXslFileName});
        this.around102_setXslFileName(null, thisJoinPoint, LogAspect.aspectInstance, theXslFileName);
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String theSuiteClassName) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setSuiteClassName$ajcjp2, (Object)this, (Object)this, (Object[])new Object[]{theSuiteClassName});
        this.around103_setSuiteClassName(null, thisJoinPoint, LogAspect.aspectInstance, theSuiteClassName);
    }

    public String getTotalDurationAsString() {
        return this.getDurationAsString(this.totalDuration);
    }

    private String getDurationAsString(long theDuration) {
        return NumberFormat.getInstance().format((double)theDuration / 1000.0);
    }

    public void setTotalDuration(long theDuration) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)setTotalDuration$ajcjp3, (Object)this, (Object)this, (Object[])new Object[]{new Long(theDuration)});
        this.around104_setTotalDuration(null, thisJoinPoint, LogAspect.aspectInstance, theDuration);
    }

    public String toXML(TestResult theResult) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)toXML$ajcjp4, (Object)this, (Object)this, (Object[])new Object[]{theResult});
        return (String)this.around105_toXML(null, thisJoinPoint, LogAspect.aspectInstance, theResult);
    }

    public void startTest(Test theTest) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)startTest$ajcjp5, (Object)this, (Object)this, (Object[])new Object[]{theTest});
        this.around106_startTest(null, thisJoinPoint, LogAspect.aspectInstance);
    }

    public void addError(Test theTest, Throwable theThrowable) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)addError$ajcjp6, (Object)this, (Object)this, (Object[])new Object[]{theTest, theThrowable});
        this.around107_addError(null, thisJoinPoint, LogAspect.aspectInstance, theTest, theThrowable);
    }

    public void addFailure(Test theTest, AssertionFailedError theError) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)addFailure$ajcjp7, (Object)this, (Object)this, (Object[])new Object[]{theTest, theError});
        this.around108_addFailure(null, thisJoinPoint, LogAspect.aspectInstance, theTest, theError);
    }

    public void endTest(Test theTest) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)endTest$ajcjp8, (Object)this, (Object)this, (Object[])new Object[]{theTest});
        this.around109_endTest(null, thisJoinPoint, LogAspect.aspectInstance, theTest);
    }

    private String xmlEncode(String theString) {
        String newString = XMLFormatter.replace(theString, '&', "&amp;");
        newString = XMLFormatter.replace(newString, '<', "&lt;");
        newString = XMLFormatter.replace(newString, '>', "&gt;");
        newString = XMLFormatter.replace(newString, '\"', "&quot;");
        return newString;
    }

    public static String replace(String theBaseString, char theChar, String theNewString) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)replace$ajcjp9, null, null, (Object[])new Object[]{theBaseString, new Character(theChar), theNewString});
        return (String)XMLFormatter.around110_replace(null, thisJoinPoint, LogAspect.aspectInstance, theBaseString, theChar, theNewString);
    }

    final Object dispatch102_setXslFileName(String theXslFileName) {
        this.xslFileName = theXslFileName;
        return null;
    }

    public final Object around102_setXslFileName(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theXslFileName) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch102_setXslFileName(theXslFileName);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch102_setXslFileName(theXslFileName);
    }

    final Object dispatch103_setSuiteClassName(String theSuiteClassName) {
        this.suiteClassName = theSuiteClassName;
        return null;
    }

    public final Object around103_setSuiteClassName(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theSuiteClassName) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch103_setSuiteClassName(theSuiteClassName);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch103_setSuiteClassName(theSuiteClassName);
    }

    final Object dispatch104_setTotalDuration(long theDuration) {
        this.totalDuration = theDuration;
        return null;
    }

    public final Object around104_setTotalDuration(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, long theDuration) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch104_setTotalDuration(theDuration);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch104_setTotalDuration(theDuration);
    }

    final String dispatch105_toXML(TestResult theResult) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        if (this.xslFileName != null) {
            xml.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.xslFileName + "\"?>");
        }
        xml.append("<testsuites>");
        xml.append("<testsuite name=\"" + this.getSuiteClassName() + "\" " + "tests" + "=\"" + theResult.runCount() + "\" " + "failures" + "=\"" + theResult.failureCount() + "\" " + "errors" + "=\"" + theResult.errorCount() + "\" " + "time" + "=\"" + this.getTotalDurationAsString() + "\">");
        xml.append(this.currentTestCaseResults.toString());
        xml.append("</testsuite>");
        xml.append("</testsuites>");
        return xml.toString();
    }

    public final Object around105_toXML(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, TestResult theResult) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            String result = this.dispatch105_toXML(theResult);
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append((Object)result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return this.dispatch105_toXML(theResult);
    }

    final Object dispatch106_startTest() {
        this.currentTestStartTime = System.currentTimeMillis();
        this.currentTestFailure = null;
        return null;
    }

    public final Object around106_startTest(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch106_startTest();
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch106_startTest();
    }

    final Object dispatch107_addError(Test theTest, Throwable theThrowable) {
        TestFailure failure = new TestFailure(theTest, theThrowable);
        StringBuffer xml = new StringBuffer();
        xml.append("<error message=\"" + this.xmlEncode(failure.thrownException().getMessage()) + "\" " + "type" + "=\"" + failure.thrownException().getClass().getName() + "\">");
        xml.append(this.xmlEncode(StringUtil.exceptionToString(failure.thrownException())));
        xml.append("</error>");
        this.currentTestFailure = xml.toString();
        return null;
    }

    public final Object around107_addError(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, Test theTest, Throwable theThrowable) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch107_addError(theTest, theThrowable);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch107_addError(theTest, theThrowable);
    }

    final Object dispatch108_addFailure(Test theTest, AssertionFailedError theError) {
        TestFailure failure = new TestFailure(theTest, (Throwable)theError);
        StringBuffer xml = new StringBuffer();
        xml.append("<failure message=\"" + this.xmlEncode(failure.thrownException().getMessage()) + "\" " + "type" + "=\"" + failure.thrownException().getClass().getName() + "\">");
        xml.append(this.xmlEncode(StringUtil.exceptionToString(failure.thrownException())));
        xml.append("</failure>");
        this.currentTestFailure = xml.toString();
        return null;
    }

    public final Object around108_addFailure(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, Test theTest, AssertionFailedError theError) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch108_addFailure(theTest, theError);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch108_addFailure(theTest, theError);
    }

    final Object dispatch109_endTest(Test theTest) {
        StringBuffer xml = new StringBuffer();
        String duration = this.getDurationAsString(System.currentTimeMillis() - this.currentTestStartTime);
        xml.append("<testcase name=\"" + JUnitVersionHelper.getTestCaseName(theTest) + "\" " + "time" + "=\"" + duration + "\">");
        if (this.currentTestFailure != null) {
            xml.append(this.currentTestFailure);
        }
        xml.append("</testcase>");
        this.currentTestCaseResults.append(xml.toString());
        return null;
    }

    public final Object around109_endTest(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, Test theTest) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch109_endTest(theTest);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch109_endTest(theTest);
    }

    static final String dispatch110_replace(String theBaseString, char theChar, String theNewString) {
        if (theBaseString == null) {
            return null;
        }
        int len = theBaseString.length() - 1;
        int pos = -1;
        while ((pos = theBaseString.indexOf(theChar, pos + 1)) > -1) {
            String before;
            if (pos == 0) {
                String after = theBaseString.substring(1);
                theBaseString = theNewString + after;
                continue;
            }
            if (pos == len) {
                before = theBaseString.substring(0, pos);
                theBaseString = before + theNewString;
                continue;
            }
            before = theBaseString.substring(0, pos);
            String after = theBaseString.substring(pos + 1);
            theBaseString = before + theNewString + after;
        }
        return theBaseString;
    }

    public static final Object around110_replace(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, String theBaseString, char theChar, String theNewString) throws LogConfigurationException {
        Log logger = LogFactory.getLog((Class)thisJoinPoint.getSignature().getDeclaringType());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            String result = XMLFormatter.dispatch110_replace(theBaseString, theChar, theNewString);
            StringBuffer exitString = new StringBuffer(thisJoinPoint.getSignature().getName());
            exitString.append(' ');
            exitString.append('=');
            exitString.append(' ');
            exitString.append('[');
            exitString.append((Object)result);
            exitString.append(']');
            logger.debug((Object)('>' + exitString.toString()));
            return result;
        }
        return XMLFormatter.dispatch110_replace(theBaseString, theChar, theNewString);
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

