/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.xml.Element;
import java.util.Iterator;

public class BoxPanel
extends SimpleContainer
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/BoxPanel.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final String WIDTH_ATTR = "width";
    private static final String BORDER_ATTR = "border";
    private int m_axis;
    private boolean m_centering;

    public BoxPanel() {
        this(2);
    }

    public BoxPanel(int axis) {
        this(axis, false);
    }

    public BoxPanel(int axis, boolean centering) {
        this.m_axis = axis;
        this.m_centering = centering;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Element panel = parent.newChildElement("bebop:boxPanel", "http://www.arsdigita.com/bebop/1.0");
            panel.addAttribute("center", String.valueOf(this.m_centering));
            panel.addAttribute("axis", String.valueOf(this.m_axis));
            this.exportAttributes(panel);
            Iterator i = this.children();
            while (i.hasNext()) {
                Component c = (Component)i.next();
                if (!c.isVisible(state)) continue;
                if (c instanceof Hidden) {
                    c.generateXML(state, parent);
                    continue;
                }
                Element cell = panel.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
                c.generateXML(state, cell);
            }
        }
    }

    public void setWidth(String w) {
        this.setAttribute(WIDTH_ATTR, w);
    }

    public void setBorder(boolean isBorder) {
        if (isBorder) {
            this.setAttribute(BORDER_ATTR, "1");
        } else {
            this.setAttribute(BORDER_ATTR, "0");
        }
    }

    public void setBorder(int border) {
        this.setAttribute(BORDER_ATTR, String.valueOf(border));
    }
}

