/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.util.Attributes;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ColumnPanel
extends SimpleContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ColumnPanel.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Constraint DEFAULT_CONSTRAINT = new Constraint();
    private int m_nCols;
    private Map m_constraints;
    private boolean m_inserted;
    private Attributes m_border;
    private Attributes m_padFrame;
    private Attributes m_pad;
    private String[] m_columnWidth;

    public ColumnPanel(int nCols) {
        this(nCols, false);
        this.makeBorder();
        this.makePadFrame();
        this.makePad();
    }

    public ColumnPanel(int nCols, boolean inserted) {
        this.m_nCols = nCols;
        this.setInserted(inserted);
        this.m_constraints = new HashMap();
        this.m_columnWidth = new String[nCols];
    }

    public void add(Component c, int constraints) {
        super.add(c);
        this.setConstraint(c, constraints);
    }

    public void setInserted(boolean inserted) {
        Assert.assertNotLocked(this);
        this.m_inserted = inserted;
    }

    public final boolean isInserted() {
        return this.m_inserted;
    }

    public final int getNumCols() {
        return this.m_nCols;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Element panel = parent.newChildElement("bebop:columnPanel", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(panel);
            this.generateChildren(state, parent, this.generateTopNodes(panel));
        }
    }

    private void makeBorder() {
        if (this.m_border == null) {
            this.m_border = new Attributes();
            this.m_border.setAttribute("cellspacing", "0");
            this.m_border.setAttribute("cellpadding", "4");
            this.m_border.setAttribute("border", "0");
            this.m_border.setAttribute("width", "100%");
        }
    }

    public void setBorderColor(String c) {
        this.makeBorder();
        this.m_border.setAttribute("bgcolor", c);
    }

    public void setBorderWidth(String w) {
        this.makeBorder();
        this.m_border.setAttribute("cellpadding", w);
    }

    public void setColumnWidth(int col, String width) {
        this.m_columnWidth[col - 1] = width;
    }

    public void setBorder(boolean b) {
        if (b) {
            this.makeBorder();
        } else {
            this.m_border = null;
        }
    }

    private void makePadFrame() {
        if (this.m_padFrame == null) {
            this.m_padFrame = new Attributes();
            this.m_padFrame.setAttribute("cellspacing", "0");
            this.m_padFrame.setAttribute("cellpadding", "6");
            this.m_padFrame.setAttribute("border", "0");
            this.m_padFrame.setAttribute("width", "100%");
        }
    }

    private void makePad() {
        if (this.m_pad == null) {
            this.m_pad = new Attributes();
            this.m_pad.setAttribute("cellspacing", "0");
            this.m_pad.setAttribute("cellpadding", "2");
            this.m_pad.setAttribute("border", "0");
            this.m_pad.setAttribute("width", "100%");
        }
    }

    public void setPadColor(String c) {
        this.makePadFrame();
        this.makePad();
        this.m_padFrame.setAttribute("bgcolor", c);
        this.m_pad.setAttribute("bgcolor", c);
    }

    public void setWidth(String w) {
        this.makePadFrame();
        this.m_padFrame.setAttribute("width", w);
    }

    public void setPadFrameWidth(String w) {
        this.makePadFrame();
        this.m_padFrame.setAttribute("cellpadding", w);
    }

    public void setPadBorder(boolean border) {
        this.makePad();
        if (border) {
            this.m_pad.setAttribute("border", "1");
        } else {
            this.m_pad.setAttribute("border", "0");
        }
    }

    public void setPadCellPadding(String padding) {
        this.makePad();
        this.m_pad.setAttribute("cellpadding", padding);
    }

    private Element generateTopNodes(Element parent) {
        if (this.isInserted()) {
            return parent;
        }
        String l_class = this.getClassAttr();
        if (this.m_border != null) {
            Element border = parent.newChildElement("bebop:border", "http://www.arsdigita.com/bebop/1.0");
            if (l_class != null) {
                this.m_border.setAttribute("class", l_class);
            }
            this.m_border.exportAttributes(border);
            parent = border;
        }
        if (this.m_padFrame != null) {
            Element padFrame = parent.newChildElement("bebop:padFrame", "http://www.arsdigita.com/bebop/1.0");
            if (l_class != null) {
                this.m_padFrame.setAttribute("class", l_class);
            }
            this.m_padFrame.exportAttributes(padFrame);
            parent = padFrame;
        }
        Element pad = parent.newChildElement("bebop:pad", "http://www.arsdigita.com/bebop/1.0");
        if (l_class != null) {
            this.m_pad.setAttribute("class", l_class);
        }
        this.m_pad.exportAttributes(pad);
        return pad;
    }

    private void generateChildren(PageState state, Element hiddenParent, Element parent) {
        int rowLen = this.m_nCols + 1;
        Element row = null;
        Element cell = null;
        Iterator i = this.children();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (!c.isVisible(state)) continue;
            if (c instanceof Hidden) {
                c.generateXML(state, hiddenParent);
                continue;
            }
            if (this.isInsert(c)) {
                c.generateXML(state, parent);
                rowLen = this.m_nCols + 1;
                continue;
            }
            if (rowLen >= this.m_nCols || this.isFullWidth(c)) {
                rowLen = 0;
                row = parent.newChildElement("bebop:panelRow", "http://www.arsdigita.com/bebop/1.0");
            }
            cell = row.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
            if (this.m_columnWidth[rowLen] != null) {
                cell.addAttribute("width", this.m_columnWidth[rowLen]);
            }
            this.getConstraint(c).exportAttributes(cell, this.m_nCols);
            c.generateXML(state, cell);
            ++rowLen;
            if (!this.isFullWidth(c)) continue;
            rowLen = this.m_nCols + 1;
        }
    }

    public void setConstraint(Component c, int constraints) {
        Assert.assertNotLocked(this);
        this.m_constraints.put(c, new Constraint(constraints));
    }

    private Constraint getConstraint(Component c) {
        Constraint result = (Constraint)this.m_constraints.get(c);
        if (result == null) {
            return DEFAULT_CONSTRAINT;
        }
        return result;
    }

    private boolean isInsert(Component c) {
        return this.getConstraint(c).isInsert();
    }

    private boolean isFullWidth(Component c) {
        return this.getConstraint(c).isFullWidth();
    }

    private static class Constraint {
        private boolean m_fullWidth;
        private boolean m_insert;
        private String m_alignment;
        private String m_halign;
        private String m_valign;

        public Constraint() {
            this(0);
        }

        public Constraint(int constraints) {
            StringBuffer s = new StringBuffer();
            if ((constraints & 7) != 0) {
                s.append(" align=\"");
                if ((constraints & 1) != 0) {
                    this.m_halign = "left";
                    s.append("left");
                } else if ((constraints & 2) != 0) {
                    this.m_halign = "center";
                    s.append("center");
                } else if ((constraints & 4) != 0) {
                    this.m_halign = "right";
                    s.append("right");
                }
                s.append("\" ");
            } else {
                this.m_halign = null;
            }
            if ((constraints & 0x38) != 0) {
                s.append(" valign=\"");
                if ((constraints & 8) != 0) {
                    this.m_valign = "top";
                    s.append("top");
                } else if ((constraints & 0x10) != 0) {
                    this.m_valign = "middle";
                    s.append("middle");
                } else if ((constraints & 0x20) != 0) {
                    this.m_valign = "bottom";
                    s.append("bottom");
                }
                s.append("\" ");
            } else {
                this.m_valign = null;
            }
            this.m_alignment = s.toString();
            this.m_fullWidth = (constraints & 0x40) != 0;
            this.m_insert = (constraints & 0x80) != 0;
        }

        public final boolean isFullWidth() {
            return this.m_fullWidth;
        }

        public final boolean isInsert() {
            return this.m_insert;
        }

        public final String getAlignment() {
            return this.m_alignment;
        }

        public final String getHAlign() {
            return this.m_halign;
        }

        public final String getVAlign() {
            return this.m_valign;
        }

        public void exportAttributes(Element cell, int nCols) {
            String halign = this.getHAlign();
            String valign = this.getVAlign();
            if (halign != null) {
                cell.addAttribute("align", halign);
            }
            if (valign != null) {
                cell.addAttribute("valign", valign);
            }
            if (this.isFullWidth()) {
                cell.addAttribute("colspan", Integer.toString(nCols));
            }
        }
    }
}

