/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ComponentSelectionModel;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.SplitWizard;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.util.Assert;

public class DynamicListWizard
extends SplitWizard
implements Resettable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/DynamicListWizard.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Label m_listLabel;
    private ToggleLink m_addLink;
    private Component m_editPane;
    private Component m_addPane;
    private Component m_list;
    private SingleSelectionModel m_sel;
    public static final String CURRENT_PANE = "cp";

    public DynamicListWizard(String listLabel, Component selector, SingleSelectionModel selectionModel, String addLinkLabel, Component defaultPane) {
        super(defaultPane);
        this.m_listLabel = new Label(listLabel);
        this.m_listLabel.setFontWeight("b");
        this.m_sel = selectionModel;
        AddEditSelectionModel csel = new AddEditSelectionModel(this.m_sel);
        this.m_sel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState s = e.getPageState();
                if (((AddEditSelectionModel)DynamicListWizard.this.getSelectionModel()).isListSelected(s)) {
                    DynamicListWizard.this.m_addLink.setSelected(s, false);
                }
            }
        });
        this.setSelectionModel(csel);
        this.m_list = selector;
        this.m_addLink = new ToggleLink(addLinkLabel);
        this.m_addLink.setClassAttr("actionLink");
        Label l = new Label(addLinkLabel);
        l.setFontWeight("b");
        this.m_addLink.setSelectedComponent(l);
        this.m_addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                if (((AddEditSelectionModel)DynamicListWizard.this.getSelectionModel()).isLinkSelected(s)) {
                    DynamicListWizard.this.getSelectionModel().clearSelection(s);
                }
            }
        });
        BoxPanel box = new BoxPanel(2);
        box.setBorder(0);
        this.layoutComponents(box);
        this.setSelector(box);
        this.setClassAttr("dynamicListWizard");
    }

    public DynamicListWizard(String listLabel, ListModelBuilder modelBuilder, String addLinkLabel, Component defaultPane) {
        this(listLabel, new List(modelBuilder), addLinkLabel, defaultPane);
    }

    public DynamicListWizard(ListModelBuilder modelBuilder, String addLinkLabel, Component defaultPane) {
        this("", new List(modelBuilder), addLinkLabel, defaultPane);
    }

    public DynamicListWizard(String listLabel, List list, String addLinkLabel, Component defaultPane) {
        this(listLabel, list, list.getSelectionModel(), addLinkLabel, defaultPane);
    }

    protected void layoutComponents(Container c) {
        c.add(this.getListLabel());
        c.add(this.getListingComponent());
        c.add(this.getAddLink());
    }

    public final Label getListLabel() {
        return this.m_listLabel;
    }

    public final Component getListingComponent() {
        return this.m_list;
    }

    public List getList() {
        Component c = this.getListingComponent();
        Assert.assertTrue(c instanceof List, "The listing component is not a List, but " + c.getClass().getName());
        return (List)c;
    }

    public final ToggleLink getAddLink() {
        return this.m_addLink;
    }

    public void reset(PageState state) {
        this.getSelectionModel().clearSelection(state);
        this.m_addLink.setSelected(state, false);
    }

    public void setAddPane(Component c) {
        Assert.assertTrue(this.m_addPane == null, "Add pane has already been set");
        if (!super.contains(c)) {
            super.add(c);
        }
        this.m_addPane = c;
    }

    public final Component getAddPane() {
        return this.m_addPane;
    }

    public void setEditPane(Component c) {
        Assert.assertTrue(this.m_editPane == null, "Edit pane has already been set");
        if (!super.contains(c)) {
            super.add(c);
        }
        this.m_editPane = c;
    }

    public final Component getEditPane() {
        return this.m_editPane;
    }

    private class AddEditSelectionModel
    implements ComponentSelectionModel {
        private SingleSelectionModel m_model;

        public AddEditSelectionModel(SingleSelectionModel model) {
            this.m_model = model;
        }

        public boolean isSelected(PageState state) {
            return this.isLinkSelected(state) || this.isListSelected(state);
        }

        public boolean isLinkSelected(PageState state) {
            return DynamicListWizard.this.getAddLink().isSelected(state);
        }

        public boolean isListSelected(PageState state) {
            return this.m_model.isSelected(state);
        }

        public Component getComponent(PageState state) {
            if (this.isLinkSelected(state)) {
                return DynamicListWizard.this.getAddPane();
            }
            if (this.isListSelected(state)) {
                return DynamicListWizard.this.getEditPane();
            }
            return DynamicListWizard.this.getDefaultPane();
        }

        public Object getSelectedKey(PageState s) {
            return this.m_model.getSelectedKey(s);
        }

        public void setSelectedKey(PageState s, Object key) {
            this.m_model.setSelectedKey(s, key);
        }

        public void clearSelection(PageState s) {
            this.m_model.clearSelection(s);
        }

        public void addChangeListener(ChangeListener l) {
            this.m_model.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.m_model.removeChangeListener(l);
        }

        public ParameterModel getStateParameter() {
            return this.m_model.getStateParameter();
        }
    }
}

