/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.FormCancelListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class FormSection
extends SimpleComponent
implements Container {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/FormSection.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$FormSection == null ? (class$com$arsdigita$bebop$FormSection = FormSection.class$("com.arsdigita.bebop.FormSection")) : class$com$arsdigita$bebop$FormSection));
    protected FormModel m_formModel;
    protected Container m_panel;
    private EventListenerList m_listeners;
    private FormSubmissionListener m_forwardSubmission;
    private FormInitListener m_forwardInit;
    private FormValidationListener m_forwardValidation;
    private FormProcessListener m_forwardProcess;
    static /* synthetic */ Class class$com$arsdigita$bebop$FormSection;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormSubmissionListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormInitListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormValidationListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormProcessListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormCancelListener;

    public FormSection() {
        this(new ColumnPanel(2, true));
    }

    public FormSection(Container panel) {
        this(panel, new FormModel("anonymous"));
    }

    protected FormSection(Container panel, FormModel model) {
        this.m_panel = panel;
        this.m_formModel = model;
        this.m_listeners = new EventListenerList();
    }

    public void addSubmissionListener(FormSubmissionListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding submission listener " + listener + " to " + this));
        }
        Assert.assertNotNull(listener, "Submission Listener");
        Assert.assertNotLocked(this);
        this.forwardSubmission();
        this.m_listeners.add(class$com$arsdigita$bebop$event$FormSubmissionListener == null ? (class$com$arsdigita$bebop$event$FormSubmissionListener = FormSection.class$("com.arsdigita.bebop.event.FormSubmissionListener")) : class$com$arsdigita$bebop$event$FormSubmissionListener, listener);
    }

    public void removeSubmissionListener(FormSubmissionListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing submission listener " + listener + " from " + this));
        }
        Assert.assertNotNull(listener, "Submission Listener");
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$FormSubmissionListener == null ? (class$com$arsdigita$bebop$event$FormSubmissionListener = FormSection.class$("com.arsdigita.bebop.event.FormSubmissionListener")) : class$com$arsdigita$bebop$event$FormSubmissionListener, listener);
    }

    protected void fireSubmitted(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        FormProcessException delayedException = null;
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$FormSubmissionListener == null ? (class$com$arsdigita$bebop$event$FormSubmissionListener = FormSection.class$("com.arsdigita.bebop.event.FormSubmissionListener")) : class$com$arsdigita$bebop$event$FormSubmissionListener);
        while (i.hasNext()) {
            FormSubmissionListener listener = (FormSubmissionListener)i.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Firing submission listener " + listener));
            }
            try {
                listener.submitted(e);
            }
            catch (FormProcessException ex) {
                delayedException = ex;
            }
        }
        if (delayedException != null) {
            throw delayedException;
        }
    }

    protected void forwardSubmission() {
        if (this.m_forwardSubmission == null) {
            this.m_forwardSubmission = this.createSubmissionListener();
            this.getModel().addSubmissionListener(this.m_forwardSubmission);
        }
    }

    protected FormSubmissionListener createSubmissionListener() {
        return new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) throws FormProcessException {
                FormSection.this.fireSubmitted(new FormSectionEvent(FormSection.this, e.getPageState(), e.getFormData()));
            }
        };
    }

    public void addInitListener(FormInitListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding init listener " + listener + " to " + this));
        }
        Assert.assertNotNull(listener, "FormInitListener");
        Assert.assertNotLocked(this);
        this.forwardInit();
        this.m_listeners.add(class$com$arsdigita$bebop$event$FormInitListener == null ? (class$com$arsdigita$bebop$event$FormInitListener = FormSection.class$("com.arsdigita.bebop.event.FormInitListener")) : class$com$arsdigita$bebop$event$FormInitListener, listener);
    }

    public void removeInitListener(FormInitListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing init listener " + listener + " from " + this));
        }
        Assert.assertNotNull(listener, "Init Listener");
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$FormInitListener == null ? (class$com$arsdigita$bebop$event$FormInitListener = FormSection.class$("com.arsdigita.bebop.event.FormInitListener")) : class$com$arsdigita$bebop$event$FormInitListener, listener);
    }

    protected void fireInit(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        Assert.assertLocked(this);
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$FormInitListener == null ? (class$com$arsdigita$bebop$event$FormInitListener = FormSection.class$("com.arsdigita.bebop.event.FormInitListener")) : class$com$arsdigita$bebop$event$FormInitListener);
        while (i.hasNext()) {
            FormInitListener listener = (FormInitListener)i.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Firing init listener " + listener));
            }
            listener.init(e);
        }
    }

    protected void forwardInit() {
        if (this.m_forwardInit == null) {
            this.m_forwardInit = this.createInitListener();
            this.getModel().addInitListener(this.m_forwardInit);
        }
    }

    protected FormInitListener createInitListener() {
        return new FormInitListener(){

            public void init(FormSectionEvent e) throws FormProcessException {
                FormSection.this.fireInit(new FormSectionEvent(FormSection.this, e.getPageState(), e.getFormData()));
            }
        };
    }

    public void addValidationListener(FormValidationListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding validation listener " + listener + " to " + this));
        }
        Assert.assertNotNull(listener, "FormValidationListener");
        Assert.assertNotLocked(this);
        this.forwardValidation();
        this.m_listeners.add(class$com$arsdigita$bebop$event$FormValidationListener == null ? (class$com$arsdigita$bebop$event$FormValidationListener = FormSection.class$("com.arsdigita.bebop.event.FormValidationListener")) : class$com$arsdigita$bebop$event$FormValidationListener, listener);
    }

    public void removeValidationListener(FormValidationListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing validation listener " + listener + " from " + this));
        }
        Assert.assertNotNull(listener, "Validation Listener");
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$FormValidationListener == null ? (class$com$arsdigita$bebop$event$FormValidationListener = FormSection.class$("com.arsdigita.bebop.event.FormValidationListener")) : class$com$arsdigita$bebop$event$FormValidationListener, listener);
    }

    protected void fireValidate(FormSectionEvent e) {
        FormData data = e.getFormData();
        Assert.assertNotNull(data, "FormData");
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$FormValidationListener == null ? (class$com$arsdigita$bebop$event$FormValidationListener = FormSection.class$("com.arsdigita.bebop.event.FormValidationListener")) : class$com$arsdigita$bebop$event$FormValidationListener);
        while (i.hasNext()) {
            try {
                FormValidationListener listener = (FormValidationListener)i.next();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Firing validation listener " + listener));
                }
                listener.validate(e);
            }
            catch (FormProcessException fpe) {
                data.addError(fpe.getMessage());
            }
        }
    }

    protected void forwardValidation() {
        if (this.m_forwardValidation == null) {
            this.m_forwardValidation = this.createValidationListener();
            this.getModel().addValidationListener(this.m_forwardValidation);
        }
    }

    protected FormValidationListener createValidationListener() {
        return new FormValidationListener(){

            public void validate(FormSectionEvent e) {
                FormSection.this.fireValidate(new FormSectionEvent(FormSection.this, e.getPageState(), e.getFormData()));
            }
        };
    }

    public void addProcessListener(FormProcessListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding process listener " + listener + " to " + this));
        }
        Assert.assertNotNull(listener, "FormProcessListener");
        Assert.assertNotLocked(this);
        this.forwardProcess();
        this.m_listeners.add(class$com$arsdigita$bebop$event$FormProcessListener == null ? (class$com$arsdigita$bebop$event$FormProcessListener = FormSection.class$("com.arsdigita.bebop.event.FormProcessListener")) : class$com$arsdigita$bebop$event$FormProcessListener, listener);
    }

    public void removeProcessListener(FormProcessListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing process listener " + listener + " from " + this));
        }
        Assert.assertNotNull(listener, "Process Listener");
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$FormProcessListener == null ? (class$com$arsdigita$bebop$event$FormProcessListener = FormSection.class$("com.arsdigita.bebop.event.FormProcessListener")) : class$com$arsdigita$bebop$event$FormProcessListener, listener);
    }

    protected void forwardProcess() {
        if (this.m_forwardProcess == null) {
            this.m_forwardProcess = this.createProcessListener();
            this.getModel().addProcessListener(this.m_forwardProcess);
        }
    }

    protected FormProcessListener createProcessListener() {
        return new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                FormSection.this.fireProcess(new FormSectionEvent(FormSection.this, e.getPageState(), e.getFormData()));
            }
        };
    }

    protected void fireProcess(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$FormProcessListener == null ? (class$com$arsdigita$bebop$event$FormProcessListener = FormSection.class$("com.arsdigita.bebop.event.FormProcessListener")) : class$com$arsdigita$bebop$event$FormProcessListener);
        while (i.hasNext()) {
            FormProcessListener listener = (FormProcessListener)i.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Firing process listener " + listener));
            }
            listener.process(e);
        }
    }

    public FormData process(PageState data) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void addCancelListener(FormCancelListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding cancel listener " + listener + " to " + this));
        }
        Assert.assertNotNull(listener, "FormCancelListener");
        Assert.assertNotLocked(this);
        this.m_listeners.add(class$com$arsdigita$bebop$event$FormCancelListener == null ? (class$com$arsdigita$bebop$event$FormCancelListener = FormSection.class$("com.arsdigita.bebop.event.FormCancelListener")) : class$com$arsdigita$bebop$event$FormCancelListener, listener);
    }

    public void removeCancelListener(FormCancelListener listener) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing cancel listener " + listener + " from " + this));
        }
        Assert.assertNotNull(listener, "Cancel Listener");
        Assert.assertNotLocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$FormCancelListener == null ? (class$com$arsdigita$bebop$event$FormCancelListener = FormSection.class$("com.arsdigita.bebop.event.FormCancelListener")) : class$com$arsdigita$bebop$event$FormCancelListener, listener);
    }

    protected void fireCancel(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$FormCancelListener == null ? (class$com$arsdigita$bebop$event$FormCancelListener = FormSection.class$("com.arsdigita.bebop.event.FormCancelListener")) : class$com$arsdigita$bebop$event$FormCancelListener);
        while (i.hasNext()) {
            FormCancelListener listener = (FormCancelListener)i.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Firing cancel listener " + listener));
            }
            listener.cancel(e);
        }
    }

    public void register(Form f, FormModel m) {
        m.mergeModel(this.getModel());
    }

    protected final FormModel getModel() {
        return this.m_formModel;
    }

    public void lock() {
        this.m_formModel.lock();
        this.m_panel.lock();
        super.lock();
    }

    public void respond(PageState state) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Container getPanel() {
        return this.m_panel;
    }

    public Iterator children() {
        return this.m_panel.children();
    }

    public void generateXML(PageState pageState, Element parent) {
        if (this.isVisible(pageState)) {
            this.m_panel.generateXML(pageState, parent);
        }
    }

    public void add(Component pc) {
        this.m_panel.add(pc);
    }

    public void add(Component pc, int constraints) {
        this.m_panel.add(pc, constraints);
    }

    public boolean contains(Object o) {
        return this.m_panel.contains(o);
    }

    public Component get(int index) {
        return this.m_panel.get(index);
    }

    public int indexOf(Component pc) {
        return this.m_panel.indexOf(pc);
    }

    public boolean isEmpty() {
        return this.m_panel.isEmpty();
    }

    public int size() {
        return this.m_panel.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

