/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class Image
extends BlockStylable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Image.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final String IMAGE_URL = "src";
    private final String ALT = "alt";
    private final String HEIGHT = "height";
    private final String WIDTH = "width";
    private final String BORDER = "border";
    private PrintListener m_printListener;

    public Image(String imageURL, String alt) {
        this.setImageURL(imageURL);
        this.setAlt(alt);
    }

    public Image(String imageURL) {
        this(imageURL, "");
    }

    public Image(PrintListener l) {
        this("");
        this.addPrintListener(l);
    }

    public void setImageURL(String imageURL) {
        Assert.assertNotLocked(this);
        this.setAttribute("src", imageURL);
    }

    public void setAlt(String alt) {
        Assert.assertNotLocked(this);
        this.setAttribute("alt", alt);
    }

    public void setHeight(String height) {
        Assert.assertNotLocked(this);
        this.setAttribute("height", height);
    }

    public void setWidth(String width) {
        Assert.assertNotLocked(this);
        this.setAttribute("width", width);
    }

    public void setBorder(String border) {
        Assert.assertNotLocked(this);
        this.setAttribute("border", border);
    }

    public void addPrintListener(PrintListener listener) throws IllegalStateException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null");
        }
        if (this.m_printListener != null) {
            throw new IllegalStateException("Too many listeners. Can only have one");
        }
        this.m_printListener = listener;
    }

    public void removePrintListener(PrintListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        if (listener != this.m_printListener) {
            throw new IllegalArgumentException("listener is not registered with this widget");
        }
        this.m_printListener = null;
    }

    public void generateXML(PageState state, Element parent) {
        if (!this.isVisible(state)) {
            return;
        }
        Image target = this.firePrintEvent(state);
        Element image = parent.newChildElement("bebop:image", "http://www.arsdigita.com/bebop/1.0");
        target.exportAttributes(image);
    }

    protected Image firePrintEvent(PageState state) {
        Image i = this;
        if (this.m_printListener != null) {
            try {
                i = (Image)this.clone();
                this.m_printListener.prepare(new PrintEvent(this, state, i));
            }
            catch (CloneNotSupportedException e) {
                i = this;
            }
        }
        return i;
    }
}

