/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ComponentSelectionModel;
import com.arsdigita.bebop.DefaultSingleSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import java.util.Map;

public class MapComponentSelectionModel
implements ComponentSelectionModel,
Lockable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/MapComponentSelectionModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SingleSelectionModel m_selModel;
    private Map m_components;
    private boolean m_locked;

    public MapComponentSelectionModel(SingleSelectionModel selModel, Map components) {
        this.m_components = components;
        this.m_selModel = selModel;
        this.m_locked = false;
    }

    public MapComponentSelectionModel(Map components) {
        this(new DefaultSingleSelectionModel(), components);
    }

    public final SingleSelectionModel getSingleSelectionModel() {
        return this.m_selModel;
    }

    public final Map getComponentsMap() {
        return this.m_components;
    }

    public Component getComponent(PageState state) {
        if (!this.isSelected(state)) {
            return null;
        }
        return (Component)this.m_components.get(this.m_selModel.getSelectedKey(state));
    }

    public void add(Object key, Component c) {
        Assert.assertNotLocked(this);
        this.m_components.put(key, c);
    }

    public boolean isSelected(PageState state) {
        return this.m_selModel.isSelected(state);
    }

    public Object getSelectedKey(PageState state) {
        return this.m_selModel.getSelectedKey(state);
    }

    public void setSelectedKey(PageState state, Object key) {
        this.m_selModel.setSelectedKey(state, key);
    }

    public void clearSelection(PageState state) {
        this.m_selModel.clearSelection(state);
    }

    public void addChangeListener(ChangeListener l) {
        Assert.assertNotLocked(this);
        this.m_selModel.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        Assert.assertNotLocked(this);
        this.m_selModel.removeChangeListener(l);
    }

    public ParameterModel getStateParameter() {
        return this.m_selModel.getStateParameter();
    }

    public final void lock() {
        this.m_locked = true;
    }

    public final boolean isLocked() {
        return this.m_locked;
    }
}

