/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;

public class Paginator
extends SimpleContainer
implements Resettable {
    private PaginationModelBuilder m_builder;
    private SingleSelectionModel m_pageNumModel;
    private SingleSelectionModel m_pageSizeModel;
    private boolean m_hiddenIfSinglePage;
    private BoxPanel m_spacePanel;
    private Label m_space;
    private static final String _SELECT_EVENT = "s";

    public Paginator(PaginationModelBuilder builder, int defaultPageSize) {
        this.m_builder = builder;
        this.m_hiddenIfSinglePage = true;
        IntegerParameter sizeParam = new IntegerParameter("ps");
        sizeParam.setDefaultValue(new Integer(defaultPageSize));
        sizeParam.setDefaultOverridesNull(true);
        this.m_pageSizeModel = new ParameterSingleSelectionModel(sizeParam);
        this.buildPaginationDisplay();
    }

    protected void buildPaginationDisplay() {
        PaginatorList list = new PaginatorList(new PageListModelBuilder(this, this.getPaginationModelBuilder()));
        this.setPageNumSelectionModel(list.getSelectionModel());
        this.m_space = new Label("&nbsp;", false);
        this.m_spacePanel = new BoxPanel(1);
        this.m_spacePanel.add(this.m_space);
        BoxPanel display = new BoxPanel(1);
        display.add(new Label(GlobalizationUtil.globalize("bebop.page")));
        display.add(list);
        display.add(this.m_space);
        this.add(display);
    }

    protected void setPageNumSelectionModel(SingleSelectionModel pageNumModel) {
        this.m_pageNumModel = pageNumModel;
    }

    public int getSelectedPageNum(PageState state) {
        String pageNum = (String)this.m_pageNumModel.getSelectedKey(state);
        if (pageNum == null) {
            this.m_pageNumModel.setSelectedKey(state, "1");
            return 1;
        }
        return Integer.parseInt(pageNum);
    }

    public void setSelectedPageNum(PageState state, int pageNum) {
        this.m_pageNumModel.setSelectedKey(state, String.valueOf(pageNum));
    }

    public int getPageSize(PageState state) {
        return (Integer)this.m_pageSizeModel.getSelectedKey(state);
    }

    public void setPageSize(PageState state, int pageSize) {
        this.m_pageSizeModel.setSelectedKey(state, new Integer(pageSize));
    }

    public int getTotalPages(PageState state) {
        int pageSize;
        int totalSize = this.m_builder.getTotalSize(this, state);
        int minSize = totalSize / (pageSize = this.getPageSize(state));
        if (minSize * pageSize == totalSize) {
            return minSize;
        }
        return minSize + 1;
    }

    public int getFirst(PageState state) {
        return (this.getSelectedPageNum(state) - 1) * this.getPageSize(state) + 1;
    }

    public int getLast(PageState state) {
        return this.getSelectedPageNum(state) * this.getPageSize(state);
    }

    public PaginationModelBuilder getPaginationModelBuilder() {
        return this.m_builder;
    }

    public boolean isHiddenIfSinglePage() {
        return this.m_hiddenIfSinglePage;
    }

    public void setHiddenIfSinglePage(boolean isHidden) {
        this.m_hiddenIfSinglePage = isHidden;
    }

    public boolean isVisible(PageState state) {
        return super.isVisible(state) && this.m_builder.isVisible(state) && (!this.m_hiddenIfSinglePage || this.m_builder.getTotalSize(this, state) > this.getPageSize(state));
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault(this.m_spacePanel, false);
        p.addComponentStateParam(this, this.m_pageSizeModel.getStateParameter());
    }

    public void reset(PageState state) {
        this.m_pageNumModel.clearSelection(state);
    }

    private class PageListModel
    extends LockableImpl
    implements ListModel {
        int m_totalSize;
        int m_pageSize;
        int m_pageCount;
        int m_current;

        public PageListModel(int totalSize, int pageSize, int current) {
            this.m_totalSize = totalSize;
            this.m_pageSize = pageSize;
            this.m_pageCount = 0;
            this.m_current = current;
        }

        public boolean next() {
            if (this.m_pageCount * this.m_pageSize < this.m_totalSize) {
                ++this.m_pageCount;
                return true;
            }
            return false;
        }

        public Object getElement() {
            if (Math.abs(this.m_current - this.m_pageCount) <= 5 || this.m_pageCount == 1 || this.m_pageCount * this.m_pageSize >= this.m_totalSize) {
                return Integer.toString(this.m_pageCount);
            }
            return ".";
        }

        public String getKey() {
            return Integer.toString(this.m_pageCount);
        }
    }

    private class PageListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        Paginator m_paginator;
        PaginationModelBuilder m_builder;

        public PageListModelBuilder(Paginator paginator, PaginationModelBuilder builder) {
            this.m_paginator = paginator;
            this.m_builder = builder;
        }

        public ListModel makeModel(List list, PageState state) {
            return new PageListModel(this.m_builder.getTotalSize(this.m_paginator, state), Paginator.this.getPageSize(state), Paginator.this.getSelectedPageNum(state));
        }
    }

    private class PaginatorList
    extends List {
        public PaginatorList(ListModelBuilder builder) {
            super(builder);
        }

        public void generateXML(PageState state, Element parent) {
            if (!this.isVisible(state)) {
                return;
            }
            if (Paginator.this.getSelectedPageNum(state) > 1) {
                state.setControlEvent(this, Paginator._SELECT_EVENT, Integer.toString(Paginator.this.getSelectedPageNum(state) - 1));
                new ControlLink(new Label("<")).generateXML(state, parent);
                new Label(" ").generateXML(state, parent);
                state.setControlEvent(this, Paginator._SELECT_EVENT, Integer.toString(Paginator.this.getSelectedPageNum(state) - 1));
                new ControlLink(new Label(GlobalizationUtil.globalize("bebop.previous"))).generateXML(state, parent);
                new Label("  ").generateXML(state, parent);
            }
            ListModel m = this.getModel(state);
            Object selKey = this.getSelectedKey(state);
            int i = 0;
            while (m.next()) {
                String key = m.getKey();
                boolean selected = selKey != null && key != null && selKey.toString().equals(key.toString());
                state.setControlEvent(this, Paginator._SELECT_EVENT, m.getKey());
                Component c = this.getCellRenderer().getComponent(this, state, m.getElement(), m.getKey(), i, selected);
                c.generateXML(state, parent);
                Paginator.this.m_space.generateXML(state, parent);
                ++i;
            }
            if (Paginator.this.getSelectedPageNum(state) < Paginator.this.getTotalPages(state)) {
                state.setControlEvent(this, Paginator._SELECT_EVENT, Integer.toString(Paginator.this.getSelectedPageNum(state) + 1));
                new Label("  ").generateXML(state, parent);
                new ControlLink(new Label(GlobalizationUtil.globalize("bebop.next"))).generateXML(state, parent);
                new Label(" ").generateXML(state, parent);
                state.setControlEvent(this, Paginator._SELECT_EVENT, Integer.toString(Paginator.this.getSelectedPageNum(state) + 1));
                new ControlLink(new Label(">")).generateXML(state, parent);
            }
            state.clearControlEvent();
        }
    }
}

