/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertyEditorModel;
import com.arsdigita.bebop.PropertyEditorModelBuilder;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.list.DefaultListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.SequentialMap;
import java.util.Iterator;
import java.util.Map;

public class PropertyEditor
extends SimpleContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PropertyEditor.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SequentialMap m_forms;
    private SequentialMap m_labels;
    private Component m_display;
    private Container m_displayPane;
    private List m_list;
    private PropertyEditorModelBuilder m_builder;
    private RequestLocal m_model;

    public PropertyEditor() {
        this(null);
    }

    public PropertyEditor(Component display) {
        this(display, new SimpleContainer());
    }

    public PropertyEditor(Component display, Container pane) {
        this.setClassAttr("propertyEditor");
        this.m_forms = new SequentialMap();
        this.m_labels = new SequentialMap();
        this.m_display = null;
        this.m_displayPane = pane;
        super.add(this.m_displayPane);
        this.m_list = new List();
        this.m_list.setCellRenderer(new IdentityCellRenderer());
        this.m_list.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState state = e.getPageState();
                Component c = null;
                c = !PropertyEditor.this.m_list.isSelected(state) ? PropertyEditor.this.m_displayPane : PropertyEditor.this.getComponent(PropertyEditor.this.getSelectedComponentKey(state));
                Iterator i = PropertyEditor.this.m_forms.values().iterator();
                while (i.hasNext()) {
                    Component f;
                    f.setVisible(state, (f = (Component)i.next()) == c);
                }
                PropertyEditor.this.m_displayPane.setVisible(state, PropertyEditor.this.m_displayPane == c);
            }
        });
        if (display != null) {
            this.setDisplayComponent(display);
        }
        this.setModelBuilder(new DefaultModelBuilder());
        this.m_model = new RequestLocal(){

            protected Object initialValue(PageState s) {
                return PropertyEditor.this.getModelBuilder().makeModel(PropertyEditor.this, s);
            }
        };
    }

    public void register(Page p) {
        Assert.assertNotNull(this.m_display, "display component");
        p.setVisibleDefault(this.m_displayPane, true);
        Iterator i = this.m_forms.values().iterator();
        while (i.hasNext()) {
            p.setVisibleDefault((Component)i.next(), false);
        }
    }

    public void showDisplayPane(PageState state) {
        this.m_list.clearSelection(state);
    }

    public void showComponent(PageState state, String key) {
        this.m_list.setSelectedKey(state, key);
    }

    public String getSelectedComponentKey(PageState state) {
        return (String)this.m_list.getSelectedKey(state);
    }

    public void setDisplayComponent(Component c) {
        if (this.m_display != null) {
            throw new IllegalStateException("Display component has already been set");
        }
        this.m_displayPane.add(c);
        this.m_displayPane.add(this.m_list);
        this.m_display = c;
    }

    public void addComponent(String key, Component c) {
        this.m_forms.put(key, c);
        super.add(c);
    }

    public void addComponent(String key, String label, Component c) {
        this.addComponent(key, c);
        this.m_labels.put(key, label);
    }

    public void add(String key, String label, Form form) {
        this.addComponent(key, label, form);
        this.addProcessListener(form);
    }

    public void add(String key, String label, Form form, Submit cancelButton) {
        this.add(key, label, form);
        this.addListeners(form, cancelButton);
    }

    public void add(String key, String label, FormSection formSection) {
        if (formSection instanceof Form) {
            throw new IllegalArgumentException("formSection is an instance of Form");
        }
        Form form = new Form("property" + key);
        form.add(new FormErrorDisplay(form), 65);
        form.add(formSection);
        form.setMethod("post");
        form.setEncType("multipart/form-data");
        this.add(key, label, form);
    }

    public void add(String key, String label, FormSection formSection, Submit cancelButton) {
        Form form = new Form("property" + key);
        form.add(new FormErrorDisplay(form), 65);
        form.add(formSection);
        form.setMethod("post");
        form.setEncType("multipart/form-data");
        this.add(key, label, form, cancelButton);
    }

    public Component getComponent(String key) {
        return (Component)this.m_forms.get(key);
    }

    public void addCancelListener(FormSection form, Submit cancelButton) {
        final Submit theButton = cancelButton;
        form.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (theButton.isSelected(state)) {
                    PropertyEditor.this.showDisplayPane(state);
                    throw new FormProcessException("Submission Cancelled");
                }
            }
        });
    }

    public void addProcessListener(FormSection form) {
        form.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                PropertyEditor.this.showDisplayPane(state);
            }
        });
    }

    public void addListeners(FormSection form, Submit cancelButton) {
        this.addCancelListener(form, cancelButton);
        this.addProcessListener(form);
    }

    public void addVisibilityListener(ActionLink l, String key) {
        final String t_key = key;
        l.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor.this.showComponent(e.getPageState(), t_key);
            }
        });
    }

    public List getList() {
        return this.m_list;
    }

    protected final PropertyEditorModelBuilder getModelBuilder() {
        return this.m_builder;
    }

    protected final void setModelBuilder(PropertyEditorModelBuilder b) {
        Assert.assertNotLocked(this);
        this.m_builder = b;
        this.m_list.setModelBuilder(new BuilderAdapter(this));
    }

    protected final PropertyEditorModel getModel(PageState s) {
        return (PropertyEditorModel)this.m_model.get(s);
    }

    public Component getDisplayComponent() {
        return this.m_display;
    }

    public Container getDisplayPane() {
        return this.m_displayPane;
    }

    protected SequentialMap getLabelsMap() {
        return this.m_labels;
    }

    public void lock() {
        this.getModelBuilder().lock();
        super.lock();
    }

    private static final class ModelAdapter
    implements ListModel {
        private PropertyEditorModel m_model;

        public ModelAdapter(PropertyEditorModel model) {
            this.m_model = model;
        }

        public boolean next() {
            return this.m_model.next();
        }

        public Object getElement() {
            return this.m_model.getComponent();
        }

        public String getKey() {
            return this.m_model.getKey().toString();
        }
    }

    private static final class BuilderAdapter
    extends LockableImpl
    implements ListModelBuilder {
        private PropertyEditor m_parent;

        public BuilderAdapter(PropertyEditor parent) {
            this.m_parent = parent;
        }

        public ListModel makeModel(List l, PageState state) {
            return new ModelAdapter(this.m_parent.getModel(state));
        }
    }

    protected static class DefaultModel
    implements PropertyEditorModel {
        protected Iterator m_iter;
        protected Map.Entry m_entry;

        public DefaultModel(Iterator iter) {
            this.m_iter = iter;
            this.m_entry = null;
        }

        public boolean next() {
            if (!this.m_iter.hasNext()) {
                this.m_entry = null;
                return false;
            }
            this.m_entry = (Map.Entry)this.m_iter.next();
            return true;
        }

        public Component getComponent() {
            Assert.assertNotNull(this.m_entry);
            ControlLink l = new ControlLink(new Label((String)this.m_entry.getValue()));
            l.setClassAttr("actionLink");
            return l;
        }

        public Object getKey() {
            Assert.assertNotNull(this.m_entry);
            return this.m_entry.getKey();
        }
    }

    protected static class DefaultModelBuilder
    extends LockableImpl
    implements PropertyEditorModelBuilder {
        protected Iterator getProperties(PropertyEditor p) {
            return p.getLabelsMap().entrySet().iterator();
        }

        public PropertyEditorModel makeModel(PropertyEditor p, PageState s) {
            return new DefaultModel(this.getProperties(p));
        }
    }

    protected static class IdentityCellRenderer
    extends DefaultListCellRenderer {
        protected IdentityCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            return (Component)value;
        }
    }
}

