/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class SplitPanel
extends SimpleContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/SplitPanel.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Component m_left;
    private Component m_right;
    private Component m_header;
    private int m_divider;
    public static final String BORDER = "border";

    public SplitPanel() {
        this(new Label("&nbsp;", false), new Label("&nbsp;", false), new Label("&nbsp;", false));
    }

    public SplitPanel(Component left, Component right) {
        this(new Label("&nbsp;", false), left, right);
    }

    public SplitPanel(Component header, Component left, Component right) {
        this.setDivider(25);
        if (header != null) {
            this.setHeader(header);
        }
        if (left != null) {
            this.setLeftComponent(left);
        }
        if (right != null) {
            this.setRightComponent(right);
        }
        this.setAttribute("cellpadding", "5");
        this.setAttribute("cellspacing", "0");
        this.setAttribute("width", "100%");
        this.setBorder(true);
    }

    public void setDivider(int divider) {
        Assert.assertNotLocked(this);
        if (divider < 0 || divider > 100) {
            throw new IllegalArgumentException("Divider must be in range 0..100");
        }
        this.m_divider = divider;
    }

    public final int getDivider() {
        return this.m_divider;
    }

    public void setBorder(boolean border) {
        this.setAttribute(BORDER, border ? "1" : "0");
    }

    public boolean getBorder() {
        String border = this.getAttribute(BORDER);
        return "1".equals(border);
    }

    public final Component getLeftComponent() {
        return this.m_left;
    }

    public final Component getRightComponent() {
        return this.m_right;
    }

    public final Component getHeader() {
        return this.m_header;
    }

    public void setHeader(Component c) {
        Assert.assertNotLocked(this);
        if (!super.contains(c)) {
            super.add(c);
        }
        this.m_header = c;
    }

    public void setLeftComponent(Component c) {
        Assert.assertNotLocked(this);
        if (!super.contains(c)) {
            super.add(c);
        }
        this.m_left = c;
    }

    public void setRightComponent(Component c) {
        Assert.assertNotLocked(this);
        if (!super.contains(c)) {
            super.add(c);
        }
        this.m_right = c;
    }

    public void generateXML(PageState state, Element parent) {
        if (!this.isVisible(state)) {
            return;
        }
        Element panel = parent.newChildElement("bebop:splitPanel", "http://www.arsdigita.com/bebop/1.0");
        this.exportAttributes(panel);
        panel.addAttribute("divider_left", Integer.toString(this.m_divider) + "%");
        panel.addAttribute("divider_right", Integer.toString(100 - this.m_divider) + "%");
        Element header = panel.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
        Element left = panel.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
        Element right = panel.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
        this.getHeader().generateXML(state, header);
        this.getLeftComponent().generateXML(state, left);
        this.getRightComponent().generateXML(state, right);
    }

    public void lock() {
        Assert.assertNotNull(this.getHeader(), "Header");
        Assert.assertNotNull(this.getLeftComponent(), "Left Component");
        Assert.assertNotNull(this.getRightComponent(), "Right Component");
        super.lock();
    }
}

