/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableHeader;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import javax.servlet.ServletException;

public class Table
extends BlockStylable
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Table.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String WIDTH = "width";
    private static final String CELL_SPACING = "cellspacing";
    private static final String CELL_PADDING = "cellpadding";
    private static final String BORDER = "border";
    private static final String SELECTED_ROW = "row";
    protected static final String CELL_EVENT = "cell";
    protected static final char SEP = ' ';
    private TableModelBuilder m_modelBuilder;
    private TableColumnModel m_columnModel;
    private TableHeader m_header;
    private RequestLocal m_tableModel;
    private SingleSelectionModel m_rowSelectionModel;
    private TableActionListener m_headerForward;
    private EventListenerList m_listeners;
    private TableCellRenderer m_defaultCellRenderer;
    private Component m_emptyView;
    private boolean m_striped = false;
    public static final TableModel EMPTY_MODEL = new TableModel(){

        public int getColumnCount() {
            return 0;
        }

        public boolean nextRow() {
            return false;
        }

        public Object getKeyAt(int column) {
            throw new IllegalStateException("TableModel is empty");
        }

        public Object getElementAt(int column) {
            throw new IllegalStateException("TableModel is empty");
        }
    };
    static /* synthetic */ Class class$com$arsdigita$bebop$event$TableActionListener;

    public Table() {
        this(new Object[0][0], new Object[0]);
    }

    public Table(Object[][] data, Object[] headers) {
        this((TableModelBuilder)new MatrixTableModelBuilder(data), headers);
    }

    public Table(TableModelBuilder b, Object[] headers) {
        this(b, new DefaultTableColumnModel(headers));
    }

    public Table(TableModelBuilder b, TableColumnModel c) {
        this.m_modelBuilder = b;
        this.m_columnModel = c;
        this.setHeader(new TableHeader(this.m_columnModel));
        this.m_rowSelectionModel = new ParameterSingleSelectionModel(new StringParameter(SELECTED_ROW));
        this.m_listeners = new EventListenerList();
        this.m_defaultCellRenderer = new DefaultTableCellRenderer();
        this.initTableModel();
    }

    public void addTableActionListener(TableActionListener l) {
        Assert.unlocked(this);
        if (this.m_headerForward == null) {
            this.m_headerForward = this.createTableActionListener();
            if (this.m_header != null) {
                this.m_header.addTableActionListener(this.m_headerForward);
            }
        }
        this.m_listeners.add(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = Table.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener, l);
    }

    public void removeTableActionListener(TableActionListener l) {
        Assert.unlocked(this);
        this.m_listeners.remove(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = Table.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener, l);
    }

    protected void fireCellSelected(PageState state, Object rowKey, Integer column) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = Table.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener);
        TableActionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new TableActionEvent(this, state, rowKey, column);
            }
            ((TableActionListener)i.next()).cellSelected(e);
        }
    }

    protected void fireHeadSelected(PageState state, Object rowKey, Integer column) {
        Iterator i = this.m_listeners.getListenerIterator(class$com$arsdigita$bebop$event$TableActionListener == null ? (class$com$arsdigita$bebop$event$TableActionListener = Table.class$("com.arsdigita.bebop.event.TableActionListener")) : class$com$arsdigita$bebop$event$TableActionListener);
        TableActionEvent e = null;
        while (i.hasNext()) {
            if (e == null) {
                e = new TableActionEvent(this, state, rowKey, column);
            }
            ((TableActionListener)i.next()).headSelected(e);
        }
    }

    protected TableActionListener createTableActionListener() {
        return new TableActionAdapter(){

            public void headSelected(TableActionEvent e) {
                Table.this.fireHeadSelected(e.getPageState(), e.getRowKey(), e.getColumn());
            }
        };
    }

    public final TableColumnModel getColumnModel() {
        return this.m_columnModel;
    }

    public void setColumnModel(TableColumnModel v) {
        Assert.unlocked(this);
        this.m_columnModel = v;
    }

    public final TableModelBuilder getModelBuilder() {
        return this.m_modelBuilder;
    }

    public void setModelBuilder(TableModelBuilder v) {
        Assert.unlocked(this);
        this.m_modelBuilder = v;
    }

    public final TableHeader getHeader() {
        return this.m_header;
    }

    public void setHeader(TableHeader v) {
        Assert.unlocked(this);
        if (this.m_headerForward != null) {
            if (this.m_header != null) {
                this.m_header.removeTableActionListener(this.m_headerForward);
            }
            if (v != null) {
                v.addTableActionListener(this.m_headerForward);
            }
        }
        this.m_header = v;
        if (this.m_header != null) {
            this.m_header.setTable(this);
        }
    }

    public TableColumn getColumn(int i) {
        return this.getColumnModel().get(i);
    }

    public void setColumn(int i, TableColumn v) {
        this.getColumnModel().set(i, v);
    }

    public final SingleSelectionModel getRowSelectionModel() {
        return this.m_rowSelectionModel;
    }

    public void setRowSelectionModel(SingleSelectionModel v) {
        Assert.unlocked(this);
        this.m_rowSelectionModel = v;
    }

    public SingleSelectionModel getColumnSelectionModel() {
        return this.getColumnModel() == null ? null : this.getColumnModel().getSelectionModel();
    }

    public void setColumnSelectionModel(SingleSelectionModel v) {
        Assert.unlocked(this);
        this.getColumnModel().setSelectionModel(v);
    }

    public void clearSelection(PageState s) {
        this.getRowSelectionModel().clearSelection(s);
        this.getColumnSelectionModel().clearSelection(s);
    }

    public final TableCellRenderer getDefaultCellRenderer() {
        return this.m_defaultCellRenderer;
    }

    public final void setDefaultCellRenderer(TableCellRenderer v) {
        this.m_defaultCellRenderer = v;
    }

    public final Component getEmptyView() {
        return this.m_emptyView;
    }

    public final void setEmptyView(Component v) {
        this.m_emptyView = v;
    }

    public String getWidth() {
        return this.getAttribute(WIDTH);
    }

    public void setWidth(String v) {
        this.setAttribute(WIDTH, v);
    }

    public String getBorder() {
        return this.getAttribute(BORDER);
    }

    public void setBorder(String v) {
        this.setAttribute(BORDER, v);
    }

    public String getCellSpacing() {
        return this.getAttribute(CELL_SPACING);
    }

    public void setCellSpacing(String v) {
        this.setAttribute(CELL_SPACING, v);
    }

    public String getCellPadding() {
        return this.getAttribute(CELL_PADDING);
    }

    public void setCellPadding(String v) {
        this.setAttribute(CELL_PADDING, v);
    }

    public void respond(PageState s) throws ServletException {
        String event = s.getControlEventName();
        String rowKey = null;
        Integer column = null;
        if (!CELL_EVENT.equals(event)) {
            throw new ServletException("Unknown event '" + event + "'");
        }
        String value = s.getControlEventValue();
        SingleSelectionModel rowSel = this.getRowSelectionModel();
        SingleSelectionModel colSel = this.getColumnSelectionModel();
        int split = value.indexOf(32);
        rowKey = value.substring(0, split);
        column = new Integer(value.substring(split + 1));
        colSel.setSelectedKey(s, column);
        rowSel.setSelectedKey(s, rowKey);
        this.fireCellSelected(s, rowKey, column);
    }

    public void register(Page p) {
        ParameterModel m = this.getRowSelectionModel().getStateParameter();
        if (m != null) {
            p.addComponentStateParam(this, m);
        }
        if ((m = this.getColumnSelectionModel().getStateParameter()) != null) {
            p.addComponentStateParam(this, m);
        }
    }

    public Iterator children() {
        return new Iterator(){
            int pos;
            {
                this.pos = Table.this.getHeader() == null ? -1 : -2;
            }

            public boolean hasNext() {
                return this.pos < Table.this.getColumnModel().size() - 1;
            }

            public Object next() {
                ++this.pos;
                if (this.pos == -1) {
                    return Table.this.getHeader();
                }
                return Table.this.getColumn(this.pos);
            }

            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator.");
            }
        };
    }

    public boolean isSelectedRow(PageState s, Object rowKey) {
        if (rowKey == null) {
            return false;
        }
        return this.getRowSelectionModel().isSelected(s) && rowKey.toString().equals(this.getRowSelectionModel().getSelectedKey(s).toString());
    }

    public boolean isSelectedColumn(PageState s, Object column) {
        if (column == null) {
            return false;
        }
        return this.getColumnSelectionModel().isSelected(s) && column.toString().equals(this.getColumnSelectionModel().getSelectedKey(s).toString());
    }

    public boolean isSelectedCell(PageState s, Object rowKey, Object column) {
        return this.isSelectedRow(s, rowKey) && this.isSelectedColumn(s, column);
    }

    public void setStriped(boolean striped) {
        this.m_striped = striped;
    }

    public boolean getStriped() {
        return this.m_striped;
    }

    protected void generateExtraXMLAttributes(PageState state, Element element) {
    }

    public void generateXML(PageState s, Element p) {
        TableModel model = this.getTableModel(s);
        boolean tableIsRegisteredWithPage = s.getPage().stateContains(this.getControler());
        if (model.nextRow()) {
            Element table = p.newChildElement("bebop:table", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(table);
            this.generateExtraXMLAttributes(s, table);
            if (this.getHeader() != null) {
                this.getHeader().generateXML(s, table);
            }
            Element tbody = table.newChildElement("bebop:tbody", "http://www.arsdigita.com/bebop/1.0");
            if (this.m_striped) {
                tbody.addAttribute("striped", "true");
            }
            int modelSize = this.getColumnModel().size();
            int row = 0;
            do {
                Element trow = tbody.newChildElement("bebop:trow", "http://www.arsdigita.com/bebop/1.0");
                for (int i = 0; i < modelSize; ++i) {
                    TableColumn tc = this.getColumn(i);
                    if (!tc.isVisible(s)) continue;
                    TableCellRenderer r = tc.getCellRenderer();
                    if (r == null) {
                        r = this.m_defaultCellRenderer;
                    }
                    int modelIndex = tc.getModelIndex();
                    Object key = model.getKeyAt(modelIndex);
                    Object value = model.getElementAt(modelIndex);
                    boolean selected = this.isSelectedCell(s, key, new Integer(i));
                    if (tableIsRegisteredWithPage) {
                        StringBuffer coords = new StringBuffer(40);
                        coords.append(model.getKeyAt(modelIndex)).append(' ').append(i);
                        s.setControlEvent(this.getControler(), CELL_EVENT, coords.toString());
                    }
                    Element cell = trow.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
                    tc.exportCellAttributes(cell);
                    r.getComponent(this, s, value, selected, key, row, i).generateXML(s, cell);
                }
                ++row;
            } while (model.nextRow());
        } else if (this.m_emptyView != null) {
            this.m_emptyView.generateXML(s, p);
        }
        if (tableIsRegisteredWithPage) {
            s.clearControlEvent();
        }
    }

    protected Component getControler() {
        return this;
    }

    public TableModel getTableModel(PageState s) {
        return (TableModel)this.m_tableModel.get(s);
    }

    private void initTableModel() {
        this.m_tableModel = new RequestLocal(){

            protected Object initialValue(PageState s) {
                return Table.this.m_modelBuilder.makeModel(Table.this, s);
            }
        };
    }

    public void lock() {
        this.getModelBuilder().lock();
        this.getColumnModel().lock();
        if (this.getHeader() != null) {
            this.getHeader().lock();
        }
        super.lock();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MatrixTableModelBuilder
    extends AbstractTableModelBuilder {
        private Object[][] m_data;

        public MatrixTableModelBuilder(Object[][] data) {
            this.m_data = data;
        }

        public TableModel makeModel(Table t, PageState s) {
            return new TableModel(this){
                private int row;
                private final /* synthetic */ MatrixTableModelBuilder this$0;
                {
                    this.this$0 = this$0;
                    this.row = -1;
                }

                public int getColumnCount() {
                    return MatrixTableModelBuilder.access$100(this.this$0)[0].length;
                }

                public boolean nextRow() {
                    return ++this.row < MatrixTableModelBuilder.access$100(this.this$0).length;
                }

                public Object getElementAt(int j) {
                    return MatrixTableModelBuilder.access$100(this.this$0)[this.row][j];
                }

                public Object getKeyAt(int j) {
                    return String.valueOf(this.row);
                }
            };
        }

        static /* synthetic */ Object[][] access$100(MatrixTableModelBuilder x0) {
            return x0.m_data;
        }
    }
}

