/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.demo.workflow;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.demo.workflow.Process;
import com.arsdigita.bebop.demo.workflow.SampleProcesses;
import com.arsdigita.bebop.demo.workflow.Task;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.Select;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.TooManyListenersException;

public class AddTask
extends Form
implements FormProcessListener,
FormSubmissionListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/AddTask.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final SingleSelectionModel m_processes;
    private OptionGroup m_deps;
    private Hidden m_id;
    private TextField m_name;
    private Submit m_add;
    private Submit m_cancel;

    public AddTask(SingleSelectionModel procs) {
        super("addTask");
        this.m_processes = procs;
        this.m_id = new Hidden("id");
        this.add(this.m_id);
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                AddTask.this.m_id.setValue(e.getPageState(), Task.getNextKey());
            }
        });
        PrintListener p = new PrintListener(){

            public void prepare(PrintEvent e) {
                Label t = (Label)e.getTarget();
                PageState s = e.getPageState();
                Assert.assertTrue(AddTask.this.m_processes.isSelected(s));
                Process inner_p = SampleProcesses.getProcess(AddTask.this.m_processes.getSelectedKey(s));
                t.setLabel("Add a new Task to " + inner_p.getName());
            }
        };
        this.add(new Label(p), 66);
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.name")));
        this.m_name = new TextField("name");
        this.m_name.addValidationListener(new NotNullValidationListener());
        this.add(this.m_name);
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.task")));
        SingleSelect taskType = new SingleSelect("task");
        try {
            taskType.addPrintListener(new TaskTypePrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("Too many listeners: " + e.getMessage(), e);
        }
        this.add(taskType);
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.description")));
        TextArea ta = new TextArea("desc");
        ta.setRows(3);
        ta.setCols(30);
        this.add(ta);
        this.addProcessListener(this);
        this.addSubmissionListener(this);
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.depends_on")), 8);
        this.m_deps = new CheckboxGroup("dep");
        try {
            this.m_deps.addPrintListener(new DependencyPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("Too many listeners: " + e.getMessage(), e);
        }
        this.add(this.m_deps);
        this.m_add = new Submit("add", "Add Task");
        this.add(this.m_add, 4);
        this.m_cancel = new Submit("cancel", "Cancel");
        this.add(this.m_cancel, 4);
    }

    public String getNewKey(PageState s) {
        return (String)this.m_id.getValue(s);
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState s = event.getPageState();
        String key = (String)this.m_id.getValue(s);
        Process p = SampleProcesses.getProcess(this.m_processes.getSelectedKey(s));
        Task t = new Task(key, (String)this.m_name.getValue(s));
        String[] deps = (String[])this.m_deps.getValue(s);
        if (deps != null) {
            for (int i = 0; i < deps.length; ++i) {
                Task d = p.getTask(deps[i]);
                if (d == null) continue;
                t.addDependency(d);
            }
        }
        p.addTask(t, false);
        this.m_id.setValue(s, Task.getNextKey());
    }

    public boolean isCancelled(PageState s) {
        return this.m_cancel.isSelected(s);
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        if (this.isCancelled(s)) {
            throw new FormProcessException("Cancel hit");
        }
    }

    private class DependencyPrintListener
    implements PrintListener {
        private DependencyPrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState s = e.getPageState();
            OptionGroup w = (OptionGroup)e.getTarget();
            Process p = SampleProcesses.getProcess(AddTask.this.m_processes.getSelectedKey(s));
            for (int i = 0; i < p.taskCount(); ++i) {
                Task t = p.getTask(i);
                w.addOption(new Option(t.getKey(), t.getName()));
            }
        }
    }

    private class TaskTypePrintListener
    implements PrintListener {
        private TaskTypePrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState s = e.getPageState();
            Select w = (Select)e.getTarget();
            ListModel m = SampleProcesses.getAllTasks(s);
            while (m.next()) {
                Task t = (Task)m.getElement();
                w.addOption(new Option(m.getKey(), t.getName()));
            }
        }
    }
}

