/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.demo.workflow;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.demo.workflow.Process;
import com.arsdigita.bebop.demo.workflow.SampleProcesses;
import com.arsdigita.bebop.demo.workflow.Task;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.Iterator;
import java.util.TooManyListenersException;

public class DisplayTask
extends Form
implements FormProcessListener,
FormSubmissionListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/DisplayTask.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SingleSelectionModel m_tasks;
    private SingleSelect m_selectAssignee;
    private SingleSelect m_addDependency;
    private Submit m_save;
    private Submit m_cancel;

    public DisplayTask(SingleSelectionModel tasks) {
        super("taskEdit");
        this.m_tasks = tasks;
        Label l = new Label(GlobalizationUtil.globalize("bebop.demo.workflow.task_details"));
        l.setFontWeight("b");
        this.add(l, 66);
        this.makeAssigneeSelect("group");
        this.makeAddDependency();
        this.m_save = new Submit("save", "Save");
        this.m_cancel = new Submit("cancel", "Cancel");
        this.add(this.m_save, 1);
        this.add(this.m_cancel, 4);
        this.addProcessListener(this);
        this.addSubmissionListener(this);
    }

    private void makeAssigneeSelect(String name) {
        String[] groups = new String[]{"Authors", "Editors", "Approvers", "Publishers", "Sharks"};
        this.m_selectAssignee = new SingleSelect(name);
        for (int i = 0; i < groups.length; ++i) {
            this.m_selectAssignee.addOption(new Option(groups[i]));
        }
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                PageState s = e.getPageState();
                FormData f = e.getFormData();
                f.put(DisplayTask.this.m_selectAssignee.getName(), DisplayTask.this.getSelectedTask(s).getAssignee());
            }
        });
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.default_assignee_group")));
        this.add(this.m_selectAssignee);
    }

    private void makeAddDependency() {
        this.m_addDependency = new SingleSelect("dep");
        try {
            this.m_addDependency.addPrintListener(new DependencyPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("Too many listeners: " + e.getMessage(), e);
        }
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.dependencies")), 64);
        this.add(this.makeDependencyTable(), 64);
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.add_dependency")));
        this.add(this.m_addDependency);
    }

    private Table makeDependencyTable() {
        Object[] headers = new String[]{"Task", "Action"};
        AbstractTableModelBuilder b = new AbstractTableModelBuilder(){

            public TableModel makeModel(Table t, PageState s) {
                return new TableModel(this, s){
                    private Iterator iter;
                    private Task current;
                    private final /* synthetic */ PageState val$s;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$s = val$s;
                        this.iter = DisplayTask.access$100(2.access$300(this.this$1), this.val$s).dependencies();
                        this.current = null;
                    }

                    public int getColumnCount() {
                        return 2;
                    }

                    public boolean nextRow() {
                        if (this.iter.hasNext()) {
                            this.current = (Task)this.iter.next();
                            return true;
                        }
                        return false;
                    }

                    public Object getElementAt(int columnIndex) {
                        if (columnIndex == 0) {
                            return this.current.getName();
                        }
                        if (columnIndex == 1) {
                            return "delete";
                        }
                        return null;
                    }

                    public Object getKeyAt(int columnIndex) {
                        return this.current.getKey();
                    }
                };
            }

            static /* synthetic */ DisplayTask access$300(2 x0) {
                return x0.DisplayTask.this;
            }
        };
        Table result = new Table((TableModelBuilder)b, headers);
        result.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(true));
        result.addTableActionListener(new DependencyTableActionListener());
        Label l = new Label(GlobalizationUtil.globalize("bebop.demo.workflow.none"));
        l.setFontWeight("i");
        l.setStyleAttr("padding-left: 3em");
        result.setEmptyView(l);
        result.setWidth("100%");
        return result;
    }

    public boolean isCancelled(PageState s) {
        return this.m_cancel.isSelected(s);
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        if (this.isCancelled(s)) {
            this.m_tasks.clearSelection(s);
            throw new FormProcessException("Cancel hit");
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        Task t = this.getSelectedTask(s);
        t.setAssignee((String)this.m_selectAssignee.getValue(s));
        String dep = (String)this.m_addDependency.getValue(s);
        Task d = t.getProcess().getTask(dep);
        t.addDependency(d);
        this.m_tasks.clearSelection(s);
    }

    private Task getSelectedTask(PageState s) {
        return SampleProcesses.getTask(this.m_tasks.getSelectedKey(s).toString());
    }

    private class DependencyTableActionListener
    extends TableActionAdapter {
        private DependencyTableActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState s = e.getPageState();
            Task t = DisplayTask.this.getSelectedTask(s);
            Task d = t.getDependency((String)e.getRowKey());
            if (d != null) {
                t.removeDependency(d);
            }
        }
    }

    private class DependencyPrintListener
    implements PrintListener {
        private DependencyPrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState s = e.getPageState();
            SingleSelect w = (SingleSelect)e.getTarget();
            Process p = DisplayTask.this.getSelectedTask(s).getProcess();
            for (int i = 0; i < p.taskCount(); ++i) {
                Task t = p.getTask(i);
                w.addOption(new Option(t.getKey(), t.getName()));
            }
        }
    }
}

