/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class Submit
extends Widget {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/Submit.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private boolean m_noDoubleClick = true;
    private GlobalizedMessage m_buttonLabel;

    public Submit(String name) {
        this(name.replace(' ', '_'), name);
    }

    public Submit(String name, String label) {
        super(name);
        this.setButtonLabel(label);
    }

    public Submit(GlobalizedMessage label) {
        super(label.getKey());
        this.setButtonLabel(label);
    }

    public Submit(String name, GlobalizedMessage label) {
        super(name);
        this.setButtonLabel(label);
    }

    public Submit(ParameterModel model) {
        super(model);
        this.setButtonLabel(model.getName());
    }

    public boolean isCompound() {
        return false;
    }

    public String getType() {
        return "submit";
    }

    public void avoidDoubleClick(boolean avoid) {
        Assert.assertNotLocked(this);
        this.m_noDoubleClick = avoid;
    }

    public void setButtonLabel(String buttonLabel) {
        this.setButtonLabel(new GlobalizedMessage(buttonLabel));
    }

    public void setButtonLabel(GlobalizedMessage buttonLabel) {
        Assert.assertNotLocked(this);
        this.m_buttonLabel = buttonLabel;
    }

    public Object getValue(PageState ps) {
        return this.getValue().localize(ps.getRequest());
    }

    public GlobalizedMessage getValue() {
        return this.m_buttonLabel;
    }

    protected void generateWidget(PageState state, Element parent) {
        Element widget = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        widget.addAttribute("type", this.getType());
        widget.addAttribute("name", this.getName());
        this.exportAttributes(widget);
        if (this.getValue(state) != null) {
            widget.addAttribute("value", (String)this.getValue(state));
        } else {
            widget.addAttribute("value", "");
        }
    }

    public boolean isSelected(PageState ps) {
        ParameterData p = this.getParameterData(ps);
        return ps != null && p.getValue() != null;
    }

    public void lock() {
        if (this.m_noDoubleClick) {
            this.setAttribute("onclick", "if(this.value == '" + this.getAttribute("value") + "') { this.value = 'Please Wait'; this.form.submit();  } ");
        }
        super.lock();
    }

    public void setSize(int n) {
        this.setAttribute("size", Integer.toString(n));
    }

    public void register(Form f, FormModel m) {
        super.register(f, m);
        m.addFormParam(new StringParameter(this.getParameterModel().getName() + ".x"));
        m.addFormParam(new StringParameter(this.getParameterModel().getName() + ".y"));
    }

    protected ParameterData getParameterData(PageState ps) {
        ParameterData data = super.getParameterData(ps);
        if (data != null && data.getValue() != null) {
            return data;
        }
        FormData fd = this.getForm().getFormData(ps);
        if (fd != null) {
            return fd.getParameter(this.getName() + ".x");
        }
        return null;
    }
}

