/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TimeParameter;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;

public class Time
extends Widget
implements BebopConstants {
    private TextField m_hour;
    private TextField m_minute;
    private TextField m_second;
    private OptionGroup m_amOrPm;
    private boolean m_showSeconds;
    private static final String ZERO = "0";

    public Time(ParameterModel model) {
        this(model, false);
    }

    public Time(ParameterModel model, boolean showSeconds) {
        super(model);
        if (!(model instanceof TimeParameter)) {
            throw new IllegalArgumentException("The Time widget " + model.getName() + " must be backed by a TimeParameter parameter model");
        }
        String name = model.getName();
        String nameHour = name + ".hour";
        String nameMinute = name + ".minute";
        String nameSecond = name + ".second";
        String nameAmOrPm = name + ".amOrPm";
        DateFormatSymbols dfs = new DateFormatSymbols();
        this.m_hour = new HourFragment(nameHour, this);
        this.m_minute = new MinuteFragment(nameMinute, this);
        this.m_showSeconds = showSeconds;
        this.m_second = this.m_showSeconds ? new SecondFragment(nameSecond, this) : null;
        this.m_amOrPm = new AmPmFragment(nameAmOrPm, this);
        this.m_hour.setMaxLength(2);
        this.m_hour.setSize(2);
        this.m_minute.setMaxLength(2);
        this.m_minute.setSize(2);
        if (this.m_showSeconds) {
            this.m_second.setMaxLength(2);
            this.m_second.setSize(2);
        }
        String[] amPmStrings = dfs.getAmPmStrings();
        for (int i = 0; i < amPmStrings.length; ++i) {
            this.m_amOrPm.addOption(new Option(String.valueOf(i), amPmStrings[i]));
        }
    }

    public Time(String name) {
        this(new TimeParameter(name));
    }

    public String getType() {
        return "time";
    }

    public void setMaxLength(int length) {
        this.setAttribute("MAXLENGTH", String.valueOf(length));
    }

    public boolean isCompound() {
        return true;
    }

    protected String getElementTag() {
        return "bebop:time";
    }

    public void generateWidget(PageState ps, Element parent) {
        if (!this.isVisible(ps)) {
            return;
        }
        Element time = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        time.addAttribute("name", this.getParameterModel().getName());
        this.m_hour.generateXML(ps, time);
        this.m_minute.generateXML(ps, time);
        if (this.m_showSeconds) {
            this.m_second.generateXML(ps, time);
        }
        this.m_amOrPm.generateXML(ps, time);
    }

    public void setDisabled() {
        this.m_hour.setDisabled();
        this.m_minute.setDisabled();
        if (this.m_showSeconds) {
            this.m_second.setDisabled();
        }
        this.m_amOrPm.setDisabled();
    }

    public void setReadOnly() {
        this.m_hour.setReadOnly();
        this.m_minute.setReadOnly();
        if (this.m_showSeconds) {
            this.m_second.setReadOnly();
        }
        this.m_amOrPm.setReadOnly();
    }

    public void setForm(Form f) {
        super.setForm(f);
        this.m_hour.setForm(f);
        this.m_minute.setForm(f);
        if (this.m_showSeconds) {
            this.m_second.setForm(f);
        }
        this.m_amOrPm.setForm(f);
    }

    private Object getFragmentValue(PageState ps, int field) {
        Date value;
        Assert.assertNotNull(ps, "PageState");
        FormData f = this.getForm().getFormData(ps);
        if (f != null && (value = (Date)f.get(this.getName())) != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(value);
            int intVal = c.get(field);
            if (field == 10 && intVal == 0) {
                intVal = 12;
            }
            return new Integer(intVal);
        }
        return null;
    }

    private class AmPmFragment
    extends SingleSelect {
        private Time parent;

        public AmPmFragment(String name, Time parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 9);
        }
    }

    private class SecondFragment
    extends TextField {
        private Time parent;

        public SecondFragment(String name, Time parent) {
            super(name);
            this.parent = parent;
            this.addValidationListener(new NumberInRangeValidationListener(0L, 59L));
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            Integer sec = (Integer)this.parent.getFragmentValue(ps, 13);
            if (sec == null) {
                return null;
            }
            if (sec < 10) {
                return Time.ZERO + sec.toString();
            }
            return sec.toString();
        }
    }

    private class MinuteFragment
    extends TextField {
        private Time parent;

        public MinuteFragment(String name, Time parent) {
            super(name);
            this.parent = parent;
            this.addValidationListener(new NumberInRangeValidationListener(0L, 59L));
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            Integer min = (Integer)this.parent.getFragmentValue(ps, 12);
            if (min == null) {
                return null;
            }
            if (min < 10) {
                return Time.ZERO + min.toString();
            }
            return min.toString();
        }
    }

    private class HourFragment
    extends TextField {
        private Time parent;

        public HourFragment(String name, Time parent) {
            super(name);
            this.parent = parent;
            this.addValidationListener(new NumberInRangeValidationListener(1L, 12L));
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 10);
        }
    }
}

