/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.util.Assert;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class ArrayParameter
extends ParameterModel {
    private static final char SEP_CHAR = '^';
    private static final char ESCAPE_CHAR = '.';
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/ArrayParameter.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected int maxCount = Integer.MAX_VALUE;
    protected int minCount = 0;
    private ParameterModel m_element;

    public ArrayParameter(String name) {
        this(new StringParameter(name));
    }

    public ArrayParameter(ParameterModel element) {
        super(element.getName());
        this.m_element = element;
    }

    public final ParameterModel getElementParameter() {
        return this.m_element;
    }

    public final void setElementParameter(ParameterModel v) {
        Assert.unlocked(this);
        this.m_element = v;
        this.setName(v.getName());
    }

    public final String marshalElement(Object value) {
        return this.getElementParameter().marshal(value);
    }

    public final Object unmarshalElement(String encoded) {
        return this.getElementParameter().unmarshal(encoded);
    }

    public Object transformValue(HttpServletRequest request) {
        String[] values = Globalization.decodeParameters(request, this.getName());
        if (values == null) {
            return null;
        }
        if (values.length != 1) {
            Object[] result = this.makeElementArray(values.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.unmarshalElement(values[i]);
            }
            return result;
        }
        return this.unmarshal(values[0]);
    }

    public String marshal(Object value) {
        if (value == null) {
            return null;
        }
        Object[] values = (Object[])value;
        if (values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return this.marshalElement(values[0]);
        }
        StringBuffer result = new StringBuffer(400);
        for (int i = 0; i < values.length; ++i) {
            result.append('^');
            this.encode(result, this.marshalElement(values[i]));
        }
        return result.toString();
    }

    private void encode(StringBuffer buf, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '^' || c == '.') {
                buf.append('.');
            }
            buf.append(c);
        }
    }

    public Object unmarshal(String value) {
        if (value.length() == 0) {
            return null;
        }
        if (!value.startsWith("^")) {
            Object[] result = this.makeElementArray(1);
            result[0] = this.unmarshalElement(value);
            return result;
        }
        boolean escape = false;
        StringBuffer buf = new StringBuffer();
        ArrayList<Object> l = new ArrayList<Object>();
        for (int end = 1; end < value.length(); ++end) {
            char c = value.charAt(end);
            if (escape) {
                buf.append(c);
                escape = false;
                continue;
            }
            if (c == '^') {
                l.add(this.unmarshalElement(buf.toString()));
                buf = new StringBuffer();
                continue;
            }
            if (c == '.') {
                escape = true;
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            if (escape) {
                throw new IllegalArgumentException("Garbled string encoding of array: '" + value + "'");
            }
            l.add(this.unmarshalElement(buf.toString()));
        }
        if (l.size() == 1) {
            Object[] result = this.makeElementArray(1);
            result[0] = this.unmarshalElement((String)l.get(0));
            return result;
        }
        return l.toArray(this.makeElementArray(l.size()));
    }

    public final void setMinValueCount(int count) {
        this.minCount = count;
    }

    public final void setMaxValueCount(int count) {
        this.minCount = count;
    }

    public final int getMinValueCount() {
        return this.minCount;
    }

    public final int getMaxValueCount() {
        return this.maxCount;
    }

    protected void validate(ParameterData data) throws FormProcessException {
        super.validate(data);
        Object[] values = (Object[])data.getValue();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                ParameterData p = new ParameterData(this.getElementParameter(), values[i]);
                this.getElementParameter().validate(p);
                data.copyErrors(p);
            }
        }
    }

    public synchronized void lock() {
        this.getElementParameter().lock();
        super.lock();
    }

    public Class getValueClass() {
        return this.makeElementArray(0).getClass();
    }

    private Object[] makeElementArray(int length) {
        return (Object[])Array.newInstance(this.getElementParameter().getValueClass(), length);
    }
}

