/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.parameters.GlobalizedParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;

public class StringInRangeValidationListener
extends GlobalizedParameterListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/StringInRangeValidationListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final int m_minLength;
    private final int m_maxLength;

    public StringInRangeValidationListener(int minLength, int maxLength) {
        StringInRangeValidationListener.validateRange(minLength, maxLength);
        this.m_minLength = minLength;
        this.m_maxLength = maxLength;
        this.setErrorText("string_in_range", this.getBundleBaseName());
    }

    public StringInRangeValidationListener(int minLength, int maxLength, GlobalizedMessage error) {
        StringInRangeValidationListener.validateRange(minLength, maxLength);
        this.m_minLength = minLength;
        this.m_maxLength = maxLength;
        this.setError(error);
    }

    public void validate(ParameterEvent e) throws FormProcessException {
        ParameterData data = e.getParameterData();
        Object obj = data.getValue();
        if (StringUtils.emptyString(obj)) {
            if (this.m_minLength > 0) {
                data.addError(this.getError());
            }
            return;
        }
        boolean isValid = true;
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            for (int i = 0; i < values.length && isValid; ++i) {
                String value = values[i];
                isValid = this.isInRange(value);
            }
        } else if (obj instanceof String) {
            String value = (String)obj;
            isValid = this.isInRange(value);
        }
        if (!isValid) {
            data.addError(this.getError());
        }
    }

    private boolean isInRange(String value) {
        int length = value.length();
        boolean isInRange = length >= this.m_minLength && length <= this.m_maxLength;
        return isInRange;
    }

    private void setErrorText(String text, String bundle) {
        this.setError(new GlobalizedMessage(text, bundle, new Object[]{new Integer(this.m_minLength), new Integer(this.m_maxLength)}));
    }

    private static void validateRange(int minLength, int maxLength) {
        Assert.truth(minLength >= 0, "Minimum length cannot be negative!");
        Assert.truth(maxLength > minLength, "Maximum length must be greater than minimum!");
    }
}

