/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.Bebop;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.w3c.tidy.Tidy;

public class TidyHTMLValidationListener
implements ParameterListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener == null ? (class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener = TidyHTMLValidationListener.class$("com.arsdigita.bebop.parameters.TidyHTMLValidationListener")) : class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener));
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final LockableProperties s_tidyProperties = new LockableProperties();
    private Tidy m_tidy;
    private boolean m_repairOriginalData = true;
    static /* synthetic */ Class class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener;

    private static Properties getJTidyProperties() {
        return s_tidyProperties;
    }

    public void setRepairPolicy(boolean repairOriginalData) {
        this.m_repairOriginalData = repairOriginalData;
    }

    public boolean repairsOriginalData() {
        return this.m_repairOriginalData;
    }

    private Tidy getInstance() {
        if (this.m_tidy == null) {
            this.m_tidy = new Tidy();
            this.m_tidy.setConfigurationFromProps(TidyHTMLValidationListener.getJTidyProperties());
        }
        return this.m_tidy;
    }

    public void validate(ParameterEvent e) {
        ParameterData data = e.getParameterData();
        String html = (String)data.getValue();
        if (html == null) {
            return;
        }
        if ("".equals(html = html.trim())) {
            return;
        }
        StringWriter errors = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(errors);
        this.getInstance().setErrout(errorWriter);
        ByteArrayInputStream in = new ByteArrayInputStream(TidyHTMLValidationListener.addTitle(html).getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getInstance().parse((InputStream)in, (OutputStream)out);
        try {
            out.close();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("Error flushig output stream: " + ex.getMessage(), ex);
        }
        ErrorMessage errorMsg = new ErrorMessage(errors.toString());
        if (errorMsg.isEmpty()) {
            if (!this.repairsOriginalData()) {
                return;
            }
            String tidiedHTML = TidyHTMLValidationListener.removeJTidyCruft(out.toString());
            if (!TidyHTMLValidationListener.equalLineByLine(html, tidiedHTML)) {
                data.setValue(tidiedHTML);
                data.addError("<p>Please verify and resubmit tidied up HTML.</p>");
            }
        } else {
            StringBuffer sb = null;
            if (errorMsg.hasErrors()) {
                sb = new StringBuffer(errorMsg.toString());
                sb.append("<p>");
                String correctErrors = "The above error(s) must be corrected, before this HTML can be tidied up.";
                sb.append("The above error(s) must be corrected, before this HTML can be tidied up.");
            } else {
                sb = new StringBuffer();
                sb.append("<p>The following errors have been found");
                if (this.repairsOriginalData()) {
                    sb.append(" and corrected");
                }
                sb.append(":</p>").append(LINE_SEPARATOR);
                sb.append(errorMsg.toString());
                if (this.repairsOriginalData()) {
                    sb.append("<p>Please resubmit the corrected HTML, if you are ");
                    sb.append("satisfied with it.</p>");
                } else {
                    sb.append("<p>Please correct and resubmit.</p>");
                }
                sb.append(LINE_SEPARATOR);
                if (this.repairsOriginalData()) {
                    data.setValue(TidyHTMLValidationListener.removeJTidyCruft(out.toString()));
                }
            }
            data.addError(sb.toString());
        }
    }

    private static String addTitle(String html) {
        return "<title></title>\n" + html;
    }

    private static String removeJTidyCruft(String html) {
        int endIndex;
        int beginIndex = html.indexOf("<body>");
        if (beginIndex < 0) {
            beginIndex = html.indexOf("<BODY>");
        }
        if ((endIndex = html.indexOf("</body>")) < 0) {
            endIndex = html.indexOf("</BODY>");
        }
        return html.substring(beginIndex + ("<body>" + LINE_SEPARATOR).length(), endIndex).trim();
    }

    private static boolean equalLineByLine(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        int CR = 13;
        int LF = 10;
        int i1 = 0;
        int i2 = 0;
        while (i1 < s1.length() || i2 < s2.length()) {
            char c2;
            boolean s2Finished;
            char c1;
            boolean s1Finished;
            boolean bl = s1Finished = i1 >= s1.length();
            if (!(s1Finished || (c1 = s1.charAt(i1)) != '\r' && c1 != '\n')) {
                ++i1;
                continue;
            }
            boolean bl2 = s2Finished = i2 >= s2.length();
            if (!(s2Finished || (c2 = s2.charAt(i2)) != '\r' && c2 != '\n')) {
                ++i2;
                continue;
            }
            if (s1Finished || s2Finished) {
                return false;
            }
            if (s1.charAt(i1) != s2.charAt(i2)) {
                return false;
            }
            ++i1;
            ++i2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String path = Bebop.getConfig().getTidyConfigFile();
        InputStream is = (class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener == null ? (class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener = TidyHTMLValidationListener.class$("com.arsdigita.bebop.parameters.TidyHTMLValidationListener")) : class$com$arsdigita$bebop$parameters$TidyHTMLValidationListener).getClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new IllegalStateException("Couldn't find " + path);
        }
        try {
            s_tidyProperties.load(is);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("Couldnt' load JTidy properties", ex);
        }
        if (!s_tidyProperties.propertyNames().hasMoreElements()) {
            throw new IllegalStateException("No properties have been loaded from " + path);
        }
        s_tidyProperties.lock();
    }

    private static class LockableProperties
    extends Properties {
        private boolean m_isLocked = false;

        public LockableProperties() {
        }

        public LockableProperties(Properties defaults) {
            super(defaults);
        }

        public void lock() {
            this.m_isLocked = true;
        }

        private void checkIfLocked() {
            if (this.m_isLocked) {
                throw new RuntimeException("The object cannot be modified once initialized.");
            }
        }

        public Object setProperty(String key, String value) {
            this.checkIfLocked();
            return super.setProperty(key, value);
        }

        public void load(InputStream is) throws IOException {
            this.checkIfLocked();
            super.load(is);
        }

        public Object put(Object key, Object value) {
            this.checkIfLocked();
            return super.put(key, value);
        }

        public void putAll(Map t) {
            this.checkIfLocked();
            super.putAll((Map<?, ?>)t);
        }
    }

    private static class ErrorMessage {
        private static final String LINE_WARNING_START = "line ";
        private boolean m_hasWarnings;
        private boolean m_hasErrors;
        private String m_formattedMessage;
        private static final List s_ignorableWarnings = new ArrayList();
        private static final List s_knownWarningSummaries;

        public ErrorMessage(String msg) {
            if (msg != null || msg.length() > 0) {
                this.format(msg);
            }
        }

        public boolean isEmpty() {
            return !this.hasWarnings() && !this.hasErrors();
        }

        public boolean hasWarnings() {
            return this.m_hasWarnings;
        }

        public boolean hasErrors() {
            return this.m_hasErrors;
        }

        public String toString() {
            return this.m_formattedMessage;
        }

        private static boolean isWarning(String line) {
            if (line == null) {
                return false;
            }
            Iterator i = s_knownWarningSummaries.iterator();
            while (i.hasNext()) {
                if (!line.startsWith((String)i.next())) continue;
                return true;
            }
            return false;
        }

        private static boolean canBeIgnored(String warning) {
            if (warning == null) {
                return true;
            }
            Iterator i = s_ignorableWarnings.iterator();
            while (i.hasNext()) {
                if (warning.indexOf((String)i.next()) <= -1) continue;
                return true;
            }
            return false;
        }

        private void format(String errorMsg) {
            StringTokenizer st = new StringTokenizer(errorMsg, LINE_SEPARATOR, false);
            ArrayList<String> warningsAndErrors = new ArrayList<String>();
            String summary = null;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith(LINE_WARNING_START)) {
                    if (ErrorMessage.canBeIgnored(token)) continue;
                    warningsAndErrors.add(StringUtils.quoteHtml(token));
                    this.m_hasWarnings = true;
                    continue;
                }
                summary = token;
                if (!st.hasMoreTokens()) break;
                summary = summary + st.nextToken("");
                break;
            }
            StringBuffer sb = new StringBuffer();
            if (warningsAndErrors.size() > 0) {
                if (warningsAndErrors.size() == 1) {
                    sb.append("<p>").append((String)warningsAndErrors.get(0));
                    sb.append("</p>").append(LINE_SEPARATOR);
                } else {
                    sb.append("<ol>").append(LINE_SEPARATOR);
                    Iterator i = warningsAndErrors.iterator();
                    while (i.hasNext()) {
                        sb.append("<li>").append((String)i.next());
                        sb.append("</li>").append(LINE_SEPARATOR);
                    }
                    sb.append("</ol>").append(LINE_SEPARATOR);
                }
            }
            if (summary != null) {
                sb.append("<blockquote><p>").append(StringUtils.quoteHtml(summary)).append("</p></blockquote>");
                this.m_hasErrors = !ErrorMessage.isWarning(summary);
            }
            this.m_formattedMessage = sb.toString();
        }

        static {
            s_ignorableWarnings.add("<table> lacks \"summary\" attribute");
            s_knownWarningSummaries = new ArrayList();
            s_knownWarningSummaries.add("The table summary attribute");
            s_knownWarningSummaries.add("Characters codes for");
        }
    }
}

