/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.caching;

import com.arsdigita.caching.CacheServlet;
import com.arsdigita.caching.DynamicList;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.SystemProperties;
import com.arsdigita.util.parameter.IntegerParameter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CacheTable {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$caching$CacheTable == null ? (class$com$arsdigita$caching$CacheTable = CacheTable.class$("com.arsdigita.caching.CacheTable")) : class$com$arsdigita$caching$CacheTable));
    private static final int MIN_CACHE_SIZE = 20;
    private static final int MAX_CACHE_SIZE = 1000000;
    private static final int MIN_CACHE_AGE = 5;
    private static final int MAX_CACHE_AGE = 2592000;
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private static final int DEFAULT_CACHE_AGE = 300;
    private static Map s_caches = new Hashtable();
    private String m_cacheID;
    private DynamicList m_list;
    public static final Browser BROWSER = new BrowserImpl(s_caches);
    static /* synthetic */ Class class$com$arsdigita$caching$CacheTable;

    public CacheTable(String id) {
        this(id, 1000, 300);
    }

    public CacheTable(String id, int defSize, int defAge) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.m_cacheID = id;
        IntegerParameter sizeParam = new IntegerParameter("waf.util.caching." + id + ".size", 1, new Integer(defSize));
        int size = (Integer)SystemProperties.get(sizeParam);
        if (size < 20 || size > 1000000) {
            s_log.warn((Object)("Cache size " + size + " was outside allowed range " + 20 + "-" + 1000000));
            size = 1000;
        }
        IntegerParameter ageParam = new IntegerParameter("waf.util.caching." + id + ".age", 1, new Integer(defAge));
        int age = (Integer)SystemProperties.get(ageParam);
        this.m_list = new DynamicList(this.m_cacheID, size, this.saneMaxAge(age));
        CacheTable.register(this.m_cacheID, this);
    }

    private static void register(String id, CacheTable cache) {
        if (s_caches.containsKey(id)) {
            throw new IllegalArgumentException("There already exists a CacheTable with the \"id\" of " + id + ": " + s_caches.get(id));
        }
        s_caches.put(id, cache);
    }

    static CacheTable getCache(String id) {
        return (CacheTable)s_caches.get(id);
    }

    public int getMaxAge() {
        return this.m_list.getMaxAge();
    }

    public synchronized void setMaxAge(int age) {
        this.m_list.setMaxAge(this.saneMaxAge(age));
    }

    private int saneMaxAge(int age) {
        if (age < 5 || age > 2592000) {
            s_log.warn((Object)("Cache age " + age + " was outside allowed range " + 5 + "-" + 2592000));
            return 300;
        }
        return age;
    }

    public long getCurrentSize() {
        return this.m_list.size();
    }

    int getMaxSize() {
        return this.m_list.getMaxSize();
    }

    private void removeLRUEntry() {
        this.m_list.removeLRUEntry();
    }

    public synchronized void put(BigDecimal key, Object value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(String key, Object value) {
        this.m_list.put(key, value);
        int hashCode = value.hashCode();
        if (s_log.isDebugEnabled()) {
            List trace = StringUtils.getStackList(new Throwable());
            String caller = (String)trace.get(2);
            s_log.debug((Object)("Put key " + key + " in cache called at " + caller + ", object is of type " + value.getClass() + " with hash code: " + hashCode));
        }
        CacheServlet.removeOutdatedFromPeers(this.m_cacheID, key, hashCode);
    }

    public synchronized void removeAll() {
        s_log.debug((Object)"removeAll");
        this.m_list.clear();
    }

    public void remove(String key) {
        CacheTable.remove(this.m_cacheID, key);
    }

    public void remove(BigDecimal key) {
        this.remove(key.toString());
    }

    public static void remove(String id, BigDecimal key) {
        CacheTable.remove(id, key.toString());
    }

    public static void remove(String id, String key) {
        CacheServlet.remove(id, key);
    }

    synchronized void removeLocally(String key) {
        this.m_list.remove(key);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removed key " + key));
        }
    }

    synchronized void removeLocallyIfOutdated(String key, int hashCode) {
        boolean removed = this.m_list.removeIfOutdated(key, hashCode);
        if (s_log.isDebugEnabled()) {
            String msg = removed ? "Removed " : "Didnt' remove ";
            msg = msg + " entry with key " + key + " hash " + hashCode;
            s_log.debug((Object)msg);
        }
    }

    public synchronized Object get(BigDecimal key) {
        return this.get(key.toString());
    }

    public synchronized Object get(String key) {
        return this.m_list.get(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BrowserImpl
    implements Browser {
        private final Map m_tableMap;

        BrowserImpl(Map tableMap) {
            if (tableMap == null) {
                throw new NullPointerException();
            }
            this.m_tableMap = tableMap;
        }

        public Set getTableIDs() {
            return new HashSet(this.m_tableMap.keySet());
        }

        public String getMaxSize(String tableID) {
            return String.valueOf(BrowserImpl.getCacheTable(tableID).getMaxSize());
        }

        public String getCurrentSize(String tableID) {
            return String.valueOf(BrowserImpl.getCacheTable(tableID).getCurrentSize());
        }

        public String getMaxAge(String tableID) {
            return String.valueOf(BrowserImpl.getCacheTable(tableID).getMaxAge());
        }

        private static CacheTable getCacheTable(String tableID) {
            if (tableID == null) {
                throw new NullPointerException();
            }
            CacheTable table = CacheTable.getCache(tableID);
            if (table == null) {
                throw new IllegalArgumentException("no such table: " + tableID);
            }
            return CacheTable.getCache(tableID);
        }

        public Set getEntrySet(String tableID) {
            return BrowserImpl.getCacheTable(tableID).m_list.entrySet();
        }
    }

    public static interface Browser {
        public Set getTableIDs();

        public String getMaxSize(String var1);

        public String getCurrentSize(String var1);

        public String getMaxAge(String var1);

        public Set getEntrySet(String var1);
    }

    private class TimeStamped
    implements TimestampedEntry {
        private long m_timestamp;
        private String m_key;
        private Object m_obj;

        TimeStamped(long timestamp, String key, Object obj) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.m_timestamp = timestamp;
            this.m_key = key;
            this.m_obj = obj;
        }

        TimeStamped(String key, Object obj) {
            this.m_timestamp = System.currentTimeMillis();
            this.m_key = key;
            this.m_obj = obj;
        }

        boolean isExpired(int seconds) {
            return System.currentTimeMillis() - this.m_timestamp > (long)seconds * 1000L;
        }

        public String getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_obj;
        }

        void setValue(Object obj) {
            this.m_obj = obj;
        }

        public Date getTimestamp() {
            return new Date(this.m_timestamp);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimestampedEntry)) {
                return false;
            }
            return this.getKey().equals(((TimestampedEntry)obj).getKey());
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }
    }

    public static interface TimestampedEntry {
        public String getKey();

        public Object getValue();

        public Date getTimestamp();
    }
}

