/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.caching;

import com.arsdigita.caching.CacheTable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class DynamicList {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$caching$DynamicList == null ? (class$com$arsdigita$caching$DynamicList = DynamicList.class$("com.arsdigita.caching.DynamicList")) : class$com$arsdigita$caching$DynamicList));
    private long m_count = 0L;
    private Node m_head;
    private Node m_tail;
    private Map m_map;
    private String m_cacheID;
    private int m_maxSize;
    private int m_maxAge;
    static /* synthetic */ Class class$com$arsdigita$caching$DynamicList;

    public DynamicList(String cacheID, int size, int age) {
        this.m_maxSize = size;
        this.setMaxAge(age);
        this.m_cacheID = cacheID;
        this.m_map = new HashMap();
    }

    public void clear() {
        this.m_head = null;
        this.m_tail = null;
        this.m_count = 0L;
        this.m_map.clear();
    }

    public void setMaxAge(int age) {
        this.m_maxAge = age;
        s_log.debug((Object)("Set max age to " + age));
    }

    public int getMaxAge() {
        return this.m_maxAge;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public void removeLRUEntry() {
        String key = this.removeTail().getKey();
        this.m_map.remove(key);
    }

    public void put(String key, Object value) {
        Node node;
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.m_count >= (long)this.m_maxSize) {
            s_log.warn((Object)("Cache full. current size: " + this.m_count + "; max size: " + this.m_maxSize));
            this.removeLRUEntry();
        }
        if ((node = (Node)this.m_map.get(key)) == null) {
            DynamicList.log(this.m_cacheID, " PUT ", key);
            this.addHead(new TimeStamped(key, value));
            this.m_map.put(key, this.m_head);
        } else {
            DynamicList.log(this.m_cacheID, "RFRSH", key);
            this.setElementAt(node, new TimeStamped(key, value));
        }
    }

    public void remove(String key) {
        DynamicList.log(this.m_cacheID, "REMUC", key);
        Node node = (Node)this.m_map.remove(key);
        if (node != null) {
            this.removeElementAt(node);
        }
    }

    public boolean removeIfOutdated(String key, int hashCode) {
        Node node = (Node)this.m_map.remove(key);
        boolean removed = false;
        if (node != null) {
            TimeStamped ts = this.getElementAt(node);
            if (ts.getValue().hashCode() != hashCode) {
                DynamicList.log(this.m_cacheID, "OUTDT", key);
                this.removeElementAt(node);
                removed = true;
            } else {
                DynamicList.log(this.m_cacheID, "VALID", key);
            }
        } else {
            DynamicList.log(this.m_cacheID, "NOENT", key);
        }
        return removed;
    }

    public Object get(String key) {
        Node node = (Node)this.m_map.remove(key);
        if (node != null) {
            TimeStamped ts = this.getElementAt(node);
            this.removeElementAt(node);
            if (ts.isExpired(this.m_maxAge)) {
                DynamicList.log(this.m_cacheID, "STALE", key);
                return null;
            }
            this.m_map.put(key, this.addHead(ts));
            DynamicList.log(this.m_cacheID, "  HIT", key);
            return ts.getValue();
        }
        DynamicList.log(this.m_cacheID, " MISS", key);
        return null;
    }

    public final long size() {
        return this.m_count;
    }

    private TimeStamped getElementAt(Node position) {
        return position == null ? null : position.m_data;
    }

    private TimeStamped removeTail() {
        TimeStamped removedData = null;
        if (this.m_count != 0L) {
            removedData = this.m_tail.m_data;
            --this.m_count;
            if (this.m_count == 0L) {
                this.m_head = null;
                this.m_tail = null;
            } else if (this.m_count == 1L) {
                this.m_head.m_next = null;
                this.m_tail = this.m_head;
            } else {
                this.m_tail = this.m_tail.m_prev;
                this.m_tail.m_next = null;
            }
        }
        return removedData;
    }

    private Node addHead(TimeStamped newElement) {
        Node newHead = new Node();
        if (this.m_count == 0L) {
            this.m_head = newHead;
            this.m_tail = newHead;
        } else if (this.m_count == 1L) {
            this.m_tail.m_prev = this.m_head = newHead;
            this.m_head.m_next = this.m_tail;
        } else {
            this.m_head.m_prev = newHead;
            newHead.m_next = this.m_head;
            this.m_head = newHead;
        }
        newHead.m_data = newElement;
        ++this.m_count;
        return newHead;
    }

    private Object setElementAt(Node position, TimeStamped newValue) {
        TimeStamped oldValue = null;
        if (position != null) {
            oldValue = position.m_data;
            position.m_data = newValue;
        }
        return oldValue;
    }

    private TimeStamped removeElementAt(Node position) {
        TimeStamped oldValue = null;
        if (position != null && this.m_count != 0L) {
            if (this.m_count == 1L) {
                this.m_head = null;
                this.m_tail = null;
            } else if (this.m_count == 2L) {
                this.m_tail = this.m_head = position.m_prev != null ? position.m_prev : position.m_next;
                this.m_tail.m_prev = null;
                this.m_tail.m_next = null;
                this.m_head.m_prev = null;
                this.m_head.m_next = null;
            } else if (position == this.m_tail) {
                position.m_prev.m_next = null;
                this.m_tail = position.m_prev;
            } else if (position == this.m_head) {
                position.m_next.m_prev = null;
                this.m_head = position.m_next;
            } else {
                position.m_prev.m_next = position.m_next;
                position.m_next.m_prev = position.m_prev;
            }
            --this.m_count;
            oldValue = position.m_data;
        }
        return oldValue;
    }

    private static void log(String cacheID, String what, String key) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)(cacheID + ": " + what + " " + key));
        }
    }

    public Set entrySet() {
        HashSet<TimeStamped> set = new HashSet<TimeStamped>();
        Node nn = this.m_head;
        while (nn != null) {
            set.add(nn.m_data);
            nn = nn.m_next;
        }
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Node {
        TimeStamped m_data;
        Node m_next;
        Node m_prev;

        Node() {
        }
    }

    private class TimeStamped
    implements CacheTable.TimestampedEntry {
        private long m_timestamp;
        private String m_key;
        private Object m_obj;

        TimeStamped(long timestamp, String key, Object obj) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.m_timestamp = timestamp;
            this.m_key = key;
            this.m_obj = obj;
        }

        TimeStamped(String key, Object obj) {
            this.m_timestamp = System.currentTimeMillis();
            this.m_key = key;
            this.m_obj = obj;
        }

        boolean isExpired(int seconds) {
            return System.currentTimeMillis() - this.m_timestamp > (long)seconds * 1000L;
        }

        public String getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_obj;
        }

        void setValue(Object obj) {
            this.m_obj = obj;
        }

        public Date getTimestamp() {
            return new Date(this.m_timestamp);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimeStamped)) {
                return false;
            }
            return this.getKey().equals(((TimeStamped)obj).getKey());
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }
    }
}

