/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.categorization;

import com.arsdigita.categorization.CategorizationException;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.CategoryNotFoundException;
import com.arsdigita.categorization.CategoryPurpose;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class CategorizedObject {
    private static final String IS_DEFAULT = "isDefault";
    private ACSObject m_data;

    public CategorizedObject(ACSObject data) {
        this.m_data = data;
    }

    public CategorizedObject(DataObject dataObject) {
        try {
            this.m_data = (ACSObject)DomainObjectFactory.newInstance(dataObject);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("An ACSObject cannot be constructed from this data object: " + dataObject);
        }
    }

    public ACSObject getObject() {
        return this.m_data;
    }

    public Collection getParentCategories() {
        LinkedList<Category> parents = new LinkedList<Category>();
        DataAssociationCursor categories = this.getParentCategoriesAssoc();
        while (categories.next()) {
            parents.add(new Category(categories.getDataObject()));
        }
        categories.close();
        return parents;
    }

    public CategoryCollection getParents() {
        return new CategoryCollection(this.getParentCategoriesAssoc());
    }

    public Collection getParentCategories(String purposeKey) {
        Iterator parents = this.getParentCategories().iterator();
        LinkedList<Category> filteredParents = new LinkedList<Category>();
        block0: while (parents.hasNext()) {
            Category category = (Category)parents.next();
            CategoryCollection ancestors = category.getDefaultAscendants();
            ancestors.addOrder("defaultAncestors");
            ancestors.next();
            if (!ancestors.next()) continue;
            Category ancestor = ancestors.getCategory();
            Iterator purposes = ancestor.getPurposes().iterator();
            while (purposes.hasNext()) {
                CategoryPurpose purpose = (CategoryPurpose)purposes.next();
                if (!purposeKey.equals(purpose.getKey())) continue;
                filteredParents.add(category);
                continue block0;
            }
        }
        return filteredParents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category getDefaultParentCategory() {
        DataAssociationCursor cursor = this.getParentCategoriesAssoc();
        cursor.addEqualsFilter("link.isDefault", Boolean.TRUE);
        try {
            if (cursor.next()) {
                Category category = new Category(cursor.getDataObject());
                return category;
            }
        }
        finally {
            cursor.close();
        }
        throw new CategoryNotFoundException("The ACSObject does not have a default parent: " + this.m_data);
    }

    public long getParentCategoryCount() {
        return this.getParentCategoriesAssoc().size();
    }

    public Iterator getDefaultAncestors() {
        Category parent;
        LinkedList<Category> ancestors = new LinkedList<Category>();
        try {
            parent = this.getDefaultParentCategory();
        }
        catch (CategorizationException e) {
            parent = null;
        }
        while (parent != null) {
            ancestors.add(parent);
            try {
                parent = parent.getDefaultParentCategory();
            }
            catch (CategorizationException ex) {
                if (parent.isRoot()) {
                    parent = null;
                    continue;
                }
                throw ex;
            }
        }
        return ancestors.iterator();
    }

    public void setDefaultParentCategory(Category parent) {
        DataObject link;
        DataAssociationCursor cursor = this.getParentCategoriesAssoc();
        boolean found = false;
        while (cursor.next()) {
            DataObject category = cursor.getDataObject();
            link = cursor.getLink();
            if (Boolean.TRUE.equals((Boolean)link.get(IS_DEFAULT))) {
                link.set(IS_DEFAULT, Boolean.FALSE);
            }
            if (parent == null || !parent.getID().equals(category.get("category.id"))) continue;
            link.set(IS_DEFAULT, Boolean.TRUE);
            found = true;
        }
        cursor.close();
        if (parent != null && !found) {
            DataAssociation assoc = (DataAssociation)DomainServiceInterfaceExposer.get(this.m_data, "categories");
            link = assoc.add(DomainServiceInterfaceExposer.getDataObject(parent));
            link.set(IS_DEFAULT, Boolean.TRUE);
        }
    }

    private DataAssociationCursor getParentCategoriesAssoc() {
        DataAssociation assoc = (DataAssociation)DomainServiceInterfaceExposer.get(this.m_data, "categories");
        assoc.addOrder("isDefault desc");
        return assoc.cursor();
    }

    public void save() {
        this.m_data.save();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CategorizedObject)) {
            return false;
        }
        CategorizedObject co = (CategorizedObject)o;
        if (this.m_data == null) {
            return co.m_data == null;
        }
        return this.m_data.equals(co.m_data);
    }

    public int hashCode() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.hashCode();
    }

    public String toString() {
        return "CategorizedObject: " + this.m_data;
    }
}

