/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.core;

import com.arsdigita.core.MessageMap;
import com.arsdigita.packaging.Check;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

abstract class BaseCheck
extends Check {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/core/BaseCheck.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final MessageMap s_messages = new MessageMap();
    PrintStream m_out = System.out;
    ClassLoader m_loader = Thread.currentThread().getContextClassLoader();
    boolean m_verbose = false;
    static /* synthetic */ Class class$com$arsdigita$core$BaseCheck;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;

    BaseCheck() {
    }

    static String message(String key) {
        Assert.exists(key, class$java$lang$String == null ? (class$java$lang$String = BaseCheck.class$("java.lang.String")) : class$java$lang$String);
        return s_messages.get(key);
    }

    void printClassLocations(String classname) {
        Iterator urls = this.getClassURLs(classname).iterator();
        while (urls.hasNext()) {
            String url = ((URL)urls.next()).toString();
            int end = url.indexOf("!");
            if (end != -1) {
                if (url.startsWith("jar:file:")) {
                    this.m_out.println("    " + url.substring(9, end));
                    continue;
                }
                this.m_out.println("    " + url.substring(0, end));
                continue;
            }
            this.m_out.println("    " + url);
        }
    }

    List getClassURLs(String classname) {
        return this.getResourceURLs(classname.replace('.', '/') + ".class");
    }

    List getResourceURLs(String resource) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = this.m_loader.getResources(resource);
            while (resources.hasMoreElements()) {
                list.add(resources.nextElement());
            }
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
        return list;
    }

    boolean isClassFound(String classname) {
        if (this.m_verbose) {
            this.m_out.println("Looking for class " + classname);
        }
        try {
            Class<?> clacc = this.m_loader.loadClass(classname);
            if (this.m_verbose) {
                this.m_out.println("Found class at " + this.getClassURLs(classname).get(0));
            }
            return true;
        }
        catch (ClassNotFoundException nfe) {
            this.m_out.println("Class not found");
            return false;
        }
    }

    void checkDuplicates(String classname) {
        if (this.m_verbose) {
            this.m_out.println("Checking for duplicates of " + classname);
        }
        if (this.getClassURLs(classname).size() > 1) {
            if (this.m_verbose) {
                this.m_out.println("Duplicates found");
            }
            this.m_out.println(BaseCheck.message("duplicate_classes"));
            this.m_out.println();
            this.printClassLocations(classname);
        } else if (this.m_verbose) {
            this.m_out.println("No duplicates");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        InputStream in = (class$com$arsdigita$core$BaseCheck == null ? (class$com$arsdigita$core$BaseCheck = BaseCheck.class$("com.arsdigita.core.BaseCheck")) : class$com$arsdigita$core$BaseCheck).getResourceAsStream("checks.messages_linux");
        Assert.exists(in, class$java$io$InputStream == null ? (class$java$io$InputStream = BaseCheck.class$("java.io.InputStream")) : class$java$io$InputStream);
        s_messages.load(new InputStreamReader(in));
    }
}

