/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.core;

import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.loader.CoreLoader;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.LegacyInitEvent;
import com.arsdigita.runtime.LegacyInitializer;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.search.converter.BaseConverter;
import com.arsdigita.search.converter.ConverterRegistry;
import com.arsdigita.search.converter.ExcelConverter;
import com.arsdigita.search.converter.OOConverter;
import com.arsdigita.search.converter.PDFConverter;
import com.arsdigita.search.converter.TextConverter;
import com.arsdigita.search.converter.WordConverter;
import com.arsdigita.ui.admin.Admin;
import com.arsdigita.ui.sitemap.SiteMap;
import com.arsdigita.util.xml.XML;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.Host;
import com.arsdigita.web.WebApp;
import com.arsdigita.workflow.simple.TaskComment;

public class Initializer
extends CompoundInitializer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/core/Initializer.java#14 $ by $Author: randyg $, $DateTime: 2004/06/11 11:26:47 $";

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL(url);
        this.add(new com.arsdigita.persistence.Initializer());
        this.add(new PDLInitializer(new ManifestSource("ccm-core.pdl.mf", new NameFilter(DbHelper.getDatabaseSuffix(database), "pdl"))));
        this.add(new LegacyInitializer("com/arsdigita/core/enterprise.init"));
    }

    public final void init(DomainInitEvent e) {
        super.init(e);
        e.getFactory();
        DomainObjectFactory.registerInstantiator("com.arsdigita.web.Host", new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dobj) {
                return new Host(dobj);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator("com.arsdigita.web.ApplicationType", new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dobj) {
                return new ApplicationType(dobj);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator("com.arsdigita.web.WebApp", new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject data) {
                return new WebApp(data);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator("com.arsdigita.workflow.simple.TaskComment", new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject data) {
                return new TaskComment(data);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator("com.arsdigita.ui.admin.Admin", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject data) {
                return new Admin(data);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator("com.arsdigita.ui.sitemap.SiteMap", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject data) {
                return new SiteMap(data);
            }
        });
        BaseConverter converter = new PDFConverter();
        ConverterRegistry.registerConverter(converter, converter.getMimeTypes());
        converter = new ExcelConverter();
        ConverterRegistry.registerConverter(converter, converter.getMimeTypes());
        converter = new WordConverter();
        ConverterRegistry.registerConverter(converter, converter.getMimeTypes());
        converter = new OOConverter();
        ConverterRegistry.registerConverter(converter, converter.getMimeTypes());
        converter = new TextConverter();
        ConverterRegistry.registerConverter(converter, converter.getMimeTypes());
    }

    public final void init(LegacyInitEvent e) {
        super.init(e);
        Session session = SessionManager.getSession();
        TransactionContext txn = session.getTransactionContext();
        txn.beginTxn();
        CoreLoader.loadHost();
        txn.commitTxn();
        XML.setupFactories();
    }
}

