/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.db;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.SequenceImpl;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class GenericSequenceImpl
extends SequenceImpl {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/db/GenericSequenceImpl.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static HashMap s_knownSequences = new HashMap();
    private static final String currentValueSelect = "select value from sequences where sequence_name = ?";
    private static final String currentValueUpdate = "update sequences set value = ? where sequence_name = ?";
    private String m_sequenceName;

    private GenericSequenceImpl(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenericSequenceImpl createSequence(String sequenceName) {
        GenericSequenceImpl gs;
        HashMap hashMap = s_knownSequences;
        synchronized (hashMap) {
            if (!s_knownSequences.containsKey(sequenceName)) {
                gs = new GenericSequenceImpl(sequenceName);
                s_knownSequences.put(sequenceName, gs);
            } else {
                gs = (GenericSequenceImpl)s_knownSequences.get(sequenceName);
            }
        }
        return gs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getNextValue() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        try {
            BigDecimal result;
            BigDecimal bigDecimal = result = this.getNextValue(conn);
            return bigDecimal;
        }
        finally {
            ConnectionManager.returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getCurrentValue() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        try {
            BigDecimal result;
            BigDecimal bigDecimal = result = this.getCurrentValue(conn);
            return bigDecimal;
        }
        finally {
            ConnectionManager.returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BigDecimal getNextValue(Connection conn) throws SQLException {
        BigDecimal value;
        block10: {
            PreparedStatement stmt = conn.prepareStatement(currentValueSelect);
            try {
                stmt.setString(1, this.m_sequenceName);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (rs.next()) {
                        value = rs.getBigDecimal("value");
                        break block10;
                    }
                    throw new SQLException("Sequence " + this.m_sequenceName + " does not exist");
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        value = value.add(new BigDecimal(1.0));
        PreparedStatement stmt2 = conn.prepareStatement(currentValueUpdate);
        try {
            stmt2.setBigDecimal(1, value);
            stmt2.setString(2, this.m_sequenceName);
            stmt2.executeUpdate();
        }
        finally {
            stmt2.close();
        }
        return value;
    }

    public synchronized BigDecimal getCurrentValue(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(currentValueSelect);
        try {
            stmt.setString(1, this.m_sequenceName);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    BigDecimal bigDecimal = rs.getBigDecimal("value");
                    return bigDecimal;
                }
                throw new SQLException("Sequence " + this.m_sequenceName + " does not exist");
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }
}

