/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.db;

import com.arsdigita.db.DbHelper;
import com.arsdigita.db.SequenceImpl;
import com.arsdigita.db.oracle.OracleSequenceImpl;
import com.arsdigita.db.postgres.PostgresSequenceImpl;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class Sequences {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/db/Sequences.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$db$Sequences == null ? (class$com$arsdigita$db$Sequences = Sequences.class$("com.arsdigita.db.Sequences")) : class$com$arsdigita$db$Sequences));
    private static final String defaultSequenceName = "acs_object_id_seq";
    static /* synthetic */ Class class$com$arsdigita$db$Sequences;

    private static SequenceImpl getSequenceImpl(Connection conn, String sequenceName) throws SQLException {
        String url = conn.getMetaData().getURL();
        switch (DbHelper.getDatabaseFromURL(url)) {
            case 1: {
                return OracleSequenceImpl.createSequence(sequenceName);
            }
            case 2: {
                return PostgresSequenceImpl.createSequence(sequenceName);
            }
        }
        DbHelper.unsupportedDatabaseError("sequences");
        return null;
    }

    public static BigDecimal getCurrentValue() throws SQLException {
        return Sequences.getCurrentValue(defaultSequenceName);
    }

    public static BigDecimal getNextValue() throws SQLException {
        return Sequences.getNextValue(defaultSequenceName);
    }

    public static BigDecimal getCurrentValue(String sequenceName) throws SQLException {
        Connection conn = SessionManager.getSession().getConnection();
        return Sequences.getNextValue(sequenceName, conn);
    }

    public static BigDecimal getNextValue(String sequenceName) throws SQLException {
        Connection conn = SessionManager.getSession().getConnection();
        return Sequences.getNextValue(sequenceName, conn);
    }

    public static BigDecimal getCurrentValue(Connection conn) throws SQLException {
        return Sequences.getCurrentValue(defaultSequenceName, conn);
    }

    public static BigDecimal getNextValue(Connection conn) throws SQLException {
        return Sequences.getNextValue(defaultSequenceName, conn);
    }

    public static BigDecimal getCurrentValue(String sequenceName, Connection conn) throws SQLException {
        return Sequences.getSequenceImpl(conn, sequenceName).getCurrentValue(conn);
    }

    public static BigDecimal getNextValue(String sequenceName, Connection conn) throws SQLException {
        return Sequences.getSequenceImpl(conn, sequenceName).getNextValue(conn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

