/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.developersupport;

import com.arsdigita.util.Assert;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Debug {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$developersupport$Debug == null ? (class$com$arsdigita$developersupport$Debug = Debug.class$("com.arsdigita.developersupport.Debug")) : class$com$arsdigita$developersupport$Debug));
    static /* synthetic */ Class class$com$arsdigita$developersupport$Debug;

    private Debug() {
    }

    public static void dumpToFile(String filename, String text) {
        Writer writer = Debug.getWriter(filename);
        if (writer == null) {
            return;
        }
        try {
            writer.write(text);
            writer.close();
        }
        catch (IOException ex) {
            s_log.error((Object)"Couldn't dump text to file", (Throwable)ex);
        }
    }

    public static void dumpToFile(String filename, char[] chars) {
        Writer writer = Debug.getWriter(filename);
        if (writer == null) {
            return;
        }
        try {
            writer.write(chars);
            writer.close();
        }
        catch (IOException ex) {
            s_log.error((Object)"Couldn't dump text to file", (Throwable)ex);
        }
    }

    private static Writer getWriter(String filename) {
        return Debug.getWriter(filename, false);
    }

    private static Writer getWriter(String filename, boolean append) {
        try {
            return new FileWriter(filename, append);
        }
        catch (IOException ex) {
            s_log.error((Object)"Couldn't create file writer", (Throwable)ex);
            return null;
        }
    }

    public static String readFile(String filename) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            return sb.toString();
        }
        catch (IOException ex) {
            s_log.error((Object)("Couldn't read " + filename), (Throwable)ex);
            return null;
        }
    }

    public static Object getPrivateField(Class klass, Object obj, String fieldName) throws SecurityException {
        Assert.assertNotNull(klass, "klass");
        Assert.assertNotNull(obj, "obj");
        Assert.assertNotNull(fieldName, "fieldName");
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException("No field named " + fieldName + " in " + klass.getName());
        }
        catch (IllegalAccessException ex) {
            throw new Error("This can't normally happen.");
        }
    }

    public static String setLevel(String loggerName, String level) {
        Logger logger = Logger.getLogger((String)loggerName);
        Level oldLevel = logger.getLevel();
        Level newLevel = Level.toLevel((String)level);
        if (newLevel != null) {
            logger.setLevel(newLevel);
            if (!newLevel.equals((Object)oldLevel)) {
                logger.log((Priority)newLevel, (Object)("================== switched level to " + newLevel));
            }
        }
        return oldLevel == null ? null : oldLevel.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

