/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dmi;

import com.arsdigita.dmi.ApplicationVersion;
import com.arsdigita.dmi.ProductXMLInterpreter;
import com.arsdigita.xmlinterp.XMLWalker;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Application {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/Application.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dmi$Application == null ? (class$com$arsdigita$dmi$Application = Application.class$("com.arsdigita.dmi.Application")) : class$com$arsdigita$dmi$Application));
    private HashMap m_versionMap = new HashMap();
    private String m_sCurrentVersionName = null;
    private String m_sDatabase = null;
    private String m_sDescription = null;
    private String m_sInstallFile = null;
    private String m_sName = null;
    static /* synthetic */ Class class$com$arsdigita$dmi$Application;

    public Application(File prodFile, String database) throws ParserConfigurationException, SAXException, IOException {
        this.m_sDatabase = database;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ProductXMLInterpreter pxi = new ProductXMLInterpreter();
        XMLWalker xmlwalker = new XMLWalker();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(prodFile);
        xmlwalker.walk(doc, pxi);
        this.m_sName = pxi.getProductName();
        this.m_sDescription = pxi.getProductDescription();
        this.m_sCurrentVersionName = pxi.getCurrentVersion();
        this.m_sInstallFile = pxi.getInstallFile(this.m_sDatabase);
        ApplicationVersion[] avArray = pxi.getVersions(this.m_sDatabase);
        if (avArray == null) {
            s_log.warn((Object)"No version history was found");
            return;
        }
        s_log.warn((Object)("avArray: " + avArray));
        for (int i = 0; i < avArray.length; ++i) {
            ApplicationVersion av = avArray[i];
            this.m_versionMap.put(av.getName(), av);
        }
    }

    public String getDatabase() {
        return this.m_sDatabase;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public String getCurrentVersion() {
        return this.m_sCurrentVersionName;
    }

    public String getDataModelInstallFileName() {
        return this.m_sInstallFile;
    }

    public ApplicationVersion[] getUpgradePath(String sVersion) {
        Vector<ApplicationVersion> v = new Vector<ApplicationVersion>();
        ApplicationVersion av = (ApplicationVersion)this.m_versionMap.get(this.m_sCurrentVersionName);
        while (av.getName().compareTo(sVersion) != 0) {
            v.insertElementAt(av, 0);
            av = (ApplicationVersion)this.m_versionMap.get(av.getPreviousVersionName());
        }
        ApplicationVersion[] avArray = new ApplicationVersion[]{};
        return v.toArray(avArray);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

