/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dmi;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.DbHelper;
import com.arsdigita.dmi.Application;
import com.arsdigita.dmi.ApplicationVersion;
import com.arsdigita.dmi.Product;
import com.arsdigita.dmi.ProductVersion;
import com.arsdigita.installer.LoadSQLPlusScript;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class DataModelInitializer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/DataModelInitializer.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static String SEQUENCE_NAME = "dmi_products_seq";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dmi$DataModelInitializer == null ? (class$com$arsdigita$dmi$DataModelInitializer = DataModelInitializer.class$("com.arsdigita.dmi.DataModelInitializer")) : class$com$arsdigita$dmi$DataModelInitializer));
    private static HashMap s_queries = null;
    private Connection m_conn = null;
    private Integer m_database = new Integer(DbHelper.getDatabase());
    static /* synthetic */ Class class$com$arsdigita$dmi$DataModelInitializer;

    public void setConnection(Connection conn) {
        this.m_conn = conn;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void initialize(String dmiDataModel) throws SQLException {
        if (!this.isDMIInstalled()) {
            s_log.warn((Object)"Installing DMI Data Model");
            this.loadDMIDataModel(dmiDataModel);
            s_log.warn((Object)"DMI Data Model Installed");
        }
    }

    public void run(File xmlFile, File rootDirectory) throws SQLException, ParserConfigurationException, SAXException, IOException {
        Application app = new Application(xmlFile, DbHelper.getDatabaseDirectory());
        BigDecimal productID = this.getProductId(app.getName());
        if (productID == null) {
            s_log.warn((Object)("Product '" + app.getName() + "' is not installed.  Installing..."));
            Product p = Product.createProduct(app.getName(), app.getDescription(), app.getCurrentVersion(), rootDirectory + File.separator + app.getDataModelInstallFileName(), app.getDescription());
            String sErrMsg = p.getCurrentVersion().getInstallErrors();
            if (sErrMsg != null) {
                s_log.warn((Object)("Errors in installing the data model: " + sErrMsg));
                throw new RuntimeException("There were errors in installing the data model.  Please review them and then either restart the server or resolve the errors. " + sErrMsg);
            }
        } else {
            s_log.warn((Object)("Product '" + app.getName() + "' installed.  Checking data model..."));
            Product p = new Product(productID);
            ProductVersion pv = p.getCurrentVersion();
            String sDmVersionName = pv.getName();
            s_log.warn((Object)("Current data model version is " + pv.getName()));
            if (sDmVersionName == app.getName()) {
                s_log.warn((Object)"Data model is up to date");
            } else {
                s_log.warn((Object)"Data model is not up to date.  Upgrading...");
                String sErrMsg = this.upgradeDataModel(p, app.getUpgradePath(sDmVersionName), rootDirectory).trim();
                if (sErrMsg.length() > 0) {
                    s_log.warn((Object)("Errors in upgrading the data model: " + sErrMsg));
                    throw new RuntimeException("There were errors in upgrading the data model.Please review them and then either restart the server or resolve the errors. " + sErrMsg);
                }
                s_log.warn((Object)("Finished Upgrading data model for " + app.getName()));
            }
        }
    }

    private void initConnection() throws SQLException {
        if (this.m_conn == null || this.m_conn.isClosed()) {
            this.m_conn = ConnectionManager.getConnection();
        }
    }

    private boolean isDMIInstalled() throws SQLException {
        this.initConnection();
        String query = this.lookupQuery("checkDMIDataModelInstalled");
        Statement stmt = this.m_conn.createStatement();
        ResultSet rset = stmt.executeQuery(query);
        rset.next();
        return rset.getBigDecimal(1).intValue() == 1;
    }

    private void loadDMIDataModel(String dmiDataModel) throws SQLException {
        this.initConnection();
        LoadSQLPlusScript ls = new LoadSQLPlusScript();
        ls.setConnection(this.m_conn);
        try {
            ls.loadSQLPlusScript(dmiDataModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private BigDecimal getProductId(String productName) throws SQLException {
        this.initConnection();
        String getProductIdFromNameSql = "select product_id from dmi_products where upper(product_name) = ?";
        PreparedStatement pstmt = this.m_conn.prepareStatement(getProductIdFromNameSql);
        pstmt.setString(1, productName.toUpperCase());
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            return null;
        }
        return rset.getBigDecimal(1);
    }

    private String upgradeDataModel(Product p, ApplicationVersion[] avUpgradePath, File rootDirectory) throws SQLException {
        String sErrMsgReturn = "";
        ProductVersion pv = null;
        for (int i = 0; i < avUpgradePath.length; ++i) {
            String sErr;
            ApplicationVersion av = avUpgradePath[i];
            if (!av.hasUpgradeDataModel() || (sErr = (pv = ProductVersion.createProductVersion(p, av.getName(), rootDirectory + File.separator + av.getUpgradeFile(), av.getDescription())).getInstallErrors()) == null || sErr.trim().length() <= 0) continue;
            sErrMsgReturn = sErrMsgReturn + "Error upgrading to data model version " + pv.getName() + ": " + sErr + " ";
        }
        return sErrMsgReturn;
    }

    private String lookupQuery(String queryName) {
        HashMap queries = (HashMap)s_queries.get(this.m_database);
        if (queries == null) {
            return null;
        }
        return queries.get(queryName).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_queries = new HashMap();
        HashMap<String, String> oracle = new HashMap<String, String>();
        oracle.put("checkDMIDataModelInstalled", "select count(*) from user_tables where upper(table_name) = 'DMI_PRODUCTS'");
        HashMap<String, String> postgres = new HashMap<String, String>();
        postgres.put("checkDMIDataModelInstalled", "select count(*) from pg_tables where upper(table_name) = 'DMI_PRODUCTS'");
        s_queries.put(new Integer(1), oracle);
        s_queries.put(new Integer(2), postgres);
    }
}

