/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dmi;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.DbHelper;
import com.arsdigita.db.Sequences;
import com.arsdigita.dmi.DataModelInitializer;
import com.arsdigita.dmi.ProductVersion;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Product {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/Product.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$dmi$Product == null ? (class$com$arsdigita$dmi$Product = Product.class$("com.arsdigita.dmi.Product")) : class$com$arsdigita$dmi$Product));
    private BigDecimal m_ID = null;
    private String m_sName = null;
    private Date m_creationDate = null;
    private String m_sDesc = null;
    private static HashMap s_queries = null;
    static /* synthetic */ Class class$com$arsdigita$dmi$Product;

    public Product() {
    }

    public Product(BigDecimal productID) throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("getProductByIDSQL"));
        pstmt.setBigDecimal(1, productID);
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            throw new SQLException("Query did not return any rows");
        }
        this.m_sName = rset.getString(1);
        this.m_creationDate = rset.getDate(2);
        this.m_sDesc = rset.getString(3);
        this.m_ID = productID;
        rset.close();
        pstmt.close();
    }

    public Product(String sName) throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("getProductByNameSQL"));
        pstmt.setString(1, sName.toUpperCase());
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            throw new SQLException("Query did not return any rows");
        }
        this.m_ID = rset.getBigDecimal(1);
        this.m_creationDate = rset.getDate(2);
        this.m_sDesc = rset.getString(3);
        this.m_sName = sName;
        rset.close();
        pstmt.close();
    }

    public static Product createProduct(String sName, String sProdDesc, String sInitVersionName, String sInstallFile, String sVersionDesc) throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        conn.setAutoCommit(false);
        Product p = null;
        try {
            p = new Product();
            p.setName(sName);
            p.setDescription(sProdDesc);
            p.save();
            ProductVersion.createProductVersion(p, sInitVersionName, sInstallFile, sVersionDesc);
        }
        catch (SQLException e) {
            conn.rollback();
            conn.setAutoCommit(true);
            throw e;
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        conn.commit();
        conn.setAutoCommit(true);
        return p;
    }

    public ProductVersion getCurrentVersion() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("getCurrentVersionSQL"));
        pstmt.setBigDecimal(1, this.m_ID);
        pstmt.setBigDecimal(2, this.m_ID);
        ResultSet rset = pstmt.executeQuery();
        if (!rset.next()) {
            throw new SQLException("Query did not return any rows");
        }
        ProductVersion pv = new ProductVersion(rset.getBigDecimal(1), this);
        rset.close();
        pstmt.close();
        return pv;
    }

    public ProductVersion[] getVersions() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        Vector<ProductVersion> vector = new Vector<ProductVersion>();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("getVersionsSQL"));
        pstmt.setBigDecimal(1, this.m_ID);
        ResultSet rset = pstmt.executeQuery();
        while (rset.next()) {
            vector.add(new ProductVersion(rset.getBigDecimal(1), this));
        }
        rset.close();
        pstmt.close();
        ProductVersion[] versionArray = new ProductVersion[1];
        return vector.toArray(versionArray);
    }

    public BigDecimal getID() {
        return this.m_ID;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDescription(String sDesc) throws IllegalStateException {
        this.m_sDesc = sDesc;
    }

    public void save() throws SQLException {
        if (this.m_ID == null) {
            this.m_ID = this.insertProduct();
            this.m_creationDate = this.getCreationDateFromDB(this.m_ID);
        } else {
            this.updateProduct();
        }
    }

    public static Product[] getProducts() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        Vector<Product> vector = new Vector<Product>();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("getProductsSQL"));
        ResultSet rset = pstmt.executeQuery(Product.lookupQuery("getProductsSQL"));
        while (rset.next()) {
            vector.add(new Product(rset.getBigDecimal(1)));
        }
        rset.close();
        pstmt.close();
        Product[] productArray = new Product[1];
        return vector.toArray(productArray);
    }

    private BigDecimal insertProduct() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("insertProductSQL"));
        BigDecimal ID = Sequences.getNextValue(DataModelInitializer.SEQUENCE_NAME);
        pstmt.setBigDecimal(1, ID);
        pstmt.setString(2, this.m_sName);
        pstmt.setString(3, this.m_sDesc);
        pstmt.executeUpdate();
        return ID;
    }

    private int updateProduct() throws SQLException {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("updateProductSQL"));
        pstmt.setString(1, this.m_sName);
        pstmt.setString(2, this.m_sDesc);
        pstmt.setBigDecimal(3, this.m_ID);
        return pstmt.executeUpdate();
    }

    private Date getCreationDateFromDB(BigDecimal ID) throws SQLException {
        Date date = null;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(Product.lookupQuery("getProductCreationDateSQL"));
        pstmt.setBigDecimal(1, ID);
        ResultSet rset = pstmt.executeQuery();
        rset.next();
        date = rset.getDate(1);
        rset.close();
        pstmt.close();
        return date;
    }

    private static String lookupQuery(String queryName) {
        Object dbDefaultValue;
        Object dbSpecificValue;
        HashMap queries = (HashMap)s_queries.get(new Integer(DbHelper.getDatabase()));
        if (queries != null && (dbSpecificValue = queries.get(queryName)) != null) {
            s_log.warn((Object)("Query specific lookup - key: " + queryName + " value: " + dbSpecificValue.toString()));
            return dbSpecificValue.toString();
        }
        queries = (HashMap)s_queries.get(new Integer(0));
        if (queries != null && (dbDefaultValue = queries.get(queryName)) != null) {
            s_log.warn((Object)("Query default lookup - key: " + queryName + " value: " + dbDefaultValue.toString()));
            return dbDefaultValue.toString();
        }
        s_log.warn((Object)("Query lookup failed for key: " + queryName));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_queries = new HashMap();
        HashMap<String, String> defaultdb = new HashMap<String, String>();
        defaultdb.put("getProductByIDSQL", "select product_name, creation_date, description from dmi_products where product_id = ?");
        defaultdb.put("getProductByNameSQL", "select product_id, creation_date, description from dmi_products where upper(sName) = ?");
        defaultdb.put("getCurrentVersionSQL", "select version_id from dmi_product_versions where product_id = ? minus select previous_version_id from dmi_product_versions where product_id = ?");
        defaultdb.put("getVersionsSQL", "select version_id from dmi_product_versions where product_id = ? order by creation_date asc");
        defaultdb.put("insertProductSQL", "insert into dmi_products (product_id, product_name, creation_date, description) values (?, ?, sysdate, ?)");
        defaultdb.put("updateProductSQL", "update dmi_products set product_name = ?, description = ? where product_id = ?");
        defaultdb.put("getProductsSQL", "select product_id from dmi_products order by creation_date asc");
        defaultdb.put("getProductCreationDateSQL", "select creation_date from dmi_products where product_id = ?");
        HashMap oracle = new HashMap();
        HashMap postgres = new HashMap();
        s_queries.put(new Integer(0), defaultdb);
        s_queries.put(new Integer(1), oracle);
        s_queries.put(new Integer(2), postgres);
    }
}

