/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.domain;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.domain.InstantiatorNotFoundException;
import com.arsdigita.domain.InstantiatorRegistryException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DomainObjectFactory {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/DomainObjectFactory.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Map s_instantiators = new HashMap();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$domain$DomainObjectFactory == null ? (class$com$arsdigita$domain$DomainObjectFactory = DomainObjectFactory.class$("com.arsdigita.domain.DomainObjectFactory")) : class$com$arsdigita$domain$DomainObjectFactory));
    static /* synthetic */ Class class$com$arsdigita$domain$DomainObjectFactory;

    public static DomainObject newInstance(DataObject dataObject) throws PersistenceException, InstantiatorNotFoundException {
        if (dataObject == null) {
            return null;
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Instantiating " + dataObject.getOID()));
        }
        DomainObjectInstantiator delegator = null;
        DomainObjectInstantiator delegate = DomainObjectFactory.getInstantiator(dataObject.getObjectType());
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Initial delegate " + delegate));
        }
        while (delegate != null && delegate != delegator) {
            delegator = delegate;
            delegate = delegator.resolveInstantiator(dataObject);
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("New delegate " + delegate));
        }
        if (delegate == null) {
            throw new InstantiatorNotFoundException("No instantiator found for dataObject " + dataObject);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Final delegate " + delegate));
        }
        return delegate.doNewInstance(dataObject);
    }

    public static DomainObject newInstance(OID oid) throws InstantiatorNotFoundException {
        if (oid == null) {
            return null;
        }
        Session session = SessionManager.getSession();
        if (session == null) {
            throw new RuntimeException("Could not retrieve a session from the session manager while instantiating a class with OID = " + oid.toString());
        }
        DataObject dataObject = session.retrieve(oid);
        if (dataObject == null) {
            throw new DataObjectNotFoundException("Could not retrieve a DataObject with OID = " + oid.toString());
        }
        return DomainObjectFactory.newInstance(dataObject);
    }

    public static synchronized DomainObjectInstantiator registerInstantiator(ObjectType dataObjectType, DomainObjectInstantiator instantiator) {
        if (null == dataObjectType) {
            throw new InstantiatorRegistryException("null", instantiator);
        }
        return s_instantiators.put(dataObjectType, instantiator);
    }

    public static DomainObjectInstantiator registerInstantiator(String dataObjectType, DomainObjectInstantiator instantiator) {
        MetadataRoot meta = SessionManager.getMetadataRoot();
        ObjectType objectType = meta.getObjectType(dataObjectType);
        if (null == objectType) {
            throw new InstantiatorRegistryException(dataObjectType, instantiator);
        }
        return DomainObjectFactory.registerInstantiator(objectType, instantiator);
    }

    public static synchronized DomainObjectInstantiator getRegisteredInstantiator(ObjectType dataObjectType) {
        return (DomainObjectInstantiator)s_instantiators.get(dataObjectType);
    }

    public static synchronized DomainObjectInstantiator getRegisteredInstantiator(String dataObjectType) {
        MetadataRoot meta = SessionManager.getMetadataRoot();
        return DomainObjectFactory.getRegisteredInstantiator(meta.getObjectType(dataObjectType));
    }

    public static synchronized DomainObjectInstantiator getInstantiator(ObjectType dataObjectType) {
        ObjectType type = dataObjectType;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Initial type " + (type == null ? null : type.getName())));
        }
        while (type != null && !s_instantiators.containsKey(type)) {
            type = type.getSupertype();
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("Parent type " + (type == null ? null : type.getName())));
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Final type " + (type == null ? null : type.getName())));
        }
        if (type != null) {
            DomainObjectInstantiator instantiator = (DomainObjectInstantiator)s_instantiators.get(type);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Found instantiator " + instantiator));
            }
            return instantiator;
        }
        return null;
    }

    public static synchronized DomainObjectInstantiator getInstantiator(String dataObjectType) {
        MetadataRoot meta = SessionManager.getMetadataRoot();
        return DomainObjectFactory.getInstantiator(meta.getObjectType(dataObjectType));
    }

    static synchronized void resetFactory() {
        s_instantiators = new HashMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

