/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.BebopObjectType;
import com.arsdigita.formbuilder.MetaObjectCollection;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;

public class MetaObject
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.MetaObject";
    public static final String TYPE_ID = "typeId";
    public static final String PRETTY_NAME = "prettyName";
    public static final String PRETTY_PLURAL = "prettyPlural";
    public static final String CLASS_NAME = "className";
    public static final String PROPERTIES_FORM = "propertiesForm";

    public MetaObject() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public MetaObject(String typeName) {
        super(typeName);
    }

    public MetaObject(ObjectType type) {
        super(type);
    }

    public MetaObject(DataObject obj) {
        super(obj);
    }

    public MetaObject(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public MetaObject(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static MetaObject create(BebopObjectType type, String prettyName, String prettyPlural, String className, String propertiesForm) {
        MetaObject o = new MetaObject();
        o.setup(type, prettyName, prettyPlural, className, propertiesForm);
        return o;
    }

    protected void setup(BebopObjectType type, String prettyName, String prettyPlural, String className, String propertiesForm) {
        this.set(TYPE_ID, type.getID());
        this.set(PRETTY_NAME, prettyName);
        this.set(PRETTY_PLURAL, prettyPlural);
        this.set(CLASS_NAME, className);
        this.set(PROPERTIES_FORM, propertiesForm);
    }

    public static MetaObject retrieve(DataObject obj) {
        return new MetaObject(obj);
    }

    public static MetaObject findByClass(BebopObjectType type, Class name) throws DataObjectNotFoundException {
        return MetaObject.findByClassName(type, name.getName());
    }

    public static MetaObject findByClassName(BebopObjectType type, String name) throws DataObjectNotFoundException {
        Session ssn = SessionManager.getSession();
        DataCollection types = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        types.addEqualsFilter(TYPE_ID, type.getID());
        types.addEqualsFilter(CLASS_NAME, name);
        if (types.next()) {
            DataObject obj = types.getDataObject();
            MetaObject t = new MetaObject(obj);
            types.close();
            return t;
        }
        throw new DataObjectNotFoundException("no such class '" + name + "' registered");
    }

    public static MetaObjectCollection getWidgets(String app, String className) throws DataObjectNotFoundException {
        return MetaObject.getWidgets(BebopObjectType.findByClassName(app, className));
    }

    public static MetaObjectCollection getWidgets(String app, Class type) throws DataObjectNotFoundException {
        return MetaObject.getWidgets(BebopObjectType.findByClass(app, type));
    }

    public static MetaObjectCollection getWidgets(BebopObjectType type) {
        Session ssn = SessionManager.getSession();
        DataCollection types = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        types.addEqualsFilter(TYPE_ID, type.getID());
        return new MetaObjectCollection(types);
    }

    public void setType(BebopObjectType type) {
        this.set(TYPE_ID, type.getID());
    }

    public BebopObjectType getType() throws DataObjectNotFoundException {
        return new BebopObjectType((BigDecimal)this.get(TYPE_ID));
    }

    public void setPrettyName(String name) {
        this.set(PRETTY_NAME, name);
    }

    public String getPrettyName() {
        return (String)this.get(PRETTY_NAME);
    }

    public void setPrettyPlural(String name) {
        this.set(PRETTY_PLURAL, name);
    }

    public String getPrettyPlural() {
        return (String)this.get(PRETTY_PLURAL);
    }

    public void setWidgetClass(Class type) {
        this.set(CLASS_NAME, type.getName());
    }

    public Class getWidgetClass() throws ClassNotFoundException {
        return Class.forName((String)this.get(CLASS_NAME));
    }

    public void setWidgetClassName(String name) {
        this.set(CLASS_NAME, name);
    }

    public String getWidgetClassName() {
        return (String)this.get(CLASS_NAME);
    }

    public void setPropertiesForm(Class type) {
        this.set(PROPERTIES_FORM, type.getName());
    }

    public Class getPropertiesForm() throws ClassNotFoundException {
        return Class.forName((String)this.get(PROPERTIES_FORM));
    }

    public void setPropertiesFormName(String name) {
        this.set(PROPERTIES_FORM, name);
    }

    public String getPropertiesFormName() {
        return (String)this.get(PROPERTIES_FORM);
    }
}

