/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.BebopObjectType;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class PersistentDataQuery
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.PersistentDataQuery";
    public static final String TYPE_ID = "typeId";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";

    public PersistentDataQuery() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public PersistentDataQuery(String typeName) {
        super(typeName);
    }

    public PersistentDataQuery(ObjectType type) {
        super(type);
    }

    public PersistentDataQuery(DataObject obj) {
        super(obj);
    }

    public PersistentDataQuery(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public PersistentDataQuery(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static Collection getQueries(BebopObjectType type) {
        Session ssn = SessionManager.getSession();
        DataCollection types = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        types.addEqualsFilter(TYPE_ID, type.getID());
        ArrayList<PersistentDataQuery> l = new ArrayList<PersistentDataQuery>();
        while (types.next()) {
            DataObject obj = types.getDataObject();
            PersistentDataQuery t = new PersistentDataQuery(obj);
            l.add(t);
        }
        return l;
    }

    public static PersistentDataQuery findByName(BebopObjectType type, String name) throws DataObjectNotFoundException {
        Session ssn = SessionManager.getSession();
        DataCollection types = ssn.retrieve(BASE_DATA_OBJECT_TYPE);
        types.addEqualsFilter(TYPE_ID, type.getID());
        types.addEqualsFilter(NAME, name);
        if (types.next()) {
            DataObject obj = types.getDataObject();
            PersistentDataQuery t = new PersistentDataQuery(obj);
            types.close();
            return t;
        }
        throw new DataObjectNotFoundException("cannot find data query called " + name);
    }

    public static PersistentDataQuery create(BebopObjectType type, String description, String name) {
        PersistentDataQuery query = new PersistentDataQuery();
        query.set(TYPE_ID, type.getID());
        query.set(NAME, name);
        query.set(DESCRIPTION, description);
        return query;
    }

    public void setTypeId(BigDecimal pack) {
        this.set(TYPE_ID, pack);
    }

    public BigDecimal getTypeId() {
        return (BigDecimal)this.get(TYPE_ID);
    }

    public void setType(BebopObjectType type) {
        this.set(TYPE_ID, type.getID());
    }

    public BebopObjectType getType() throws DataObjectNotFoundException {
        return new BebopObjectType((BigDecimal)this.get(TYPE_ID));
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String name) {
        this.set(NAME, name);
    }
}

