/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.AttributeMetaData;
import com.arsdigita.formbuilder.AttributeMetaDataList;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentOption;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.util.PersistentContainerHelper;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class PersistentOptionGroup
extends PersistentWidget {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentOptionGroup.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$PersistentOptionGroup == null ? (class$com$arsdigita$formbuilder$PersistentOptionGroup = PersistentOptionGroup.class$("com.arsdigita.formbuilder.PersistentOptionGroup")) : class$com$arsdigita$formbuilder$PersistentOptionGroup));
    private PersistentContainerHelper m_container = new PersistentContainerHelper(this);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.Widget";
    private static final String TOO_MANY_OPTIONS_SELECTED = "Only one option may be selected by default on this option group.";
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentOptionGroup;

    public PersistentOptionGroup(String typeName) {
        super(typeName);
    }

    public PersistentOptionGroup(ObjectType type) {
        super(type);
    }

    public PersistentOptionGroup(DataObject obj) {
        super(obj);
    }

    public PersistentOptionGroup(OID oID) throws DataObjectNotFoundException {
        super(oID);
    }

    public void delete() {
        this.clearOptions();
        super.delete();
    }

    public abstract Component createComponent();

    public void addOption(PersistentOption option) {
        this.m_container.addComponent(option);
    }

    public void addOption(PersistentOption option, boolean selected) {
        this.m_container.addComponent(option);
        this.setOptionSelected(option, selected);
    }

    public void addOption(PersistentOption option, int position) {
        this.m_container.addComponent((PersistentComponentFactory)option, position);
    }

    public void addOption(PersistentOption option, int position, boolean selected) {
        this.m_container.addComponent((PersistentComponentFactory)option, position);
        this.setOptionSelected(option, selected);
    }

    public void removeOption(PersistentOption option) {
        this.m_container.removeComponent(option);
    }

    public void setOptionSelected(PersistentOption option, boolean selected) {
        if (!this.isMultiple()) {
            Assert.assertTrue(this.getSelectedOptions().size() == 0, TOO_MANY_OPTIONS_SELECTED);
        }
        this.m_container.setComponentSelected(option, selected);
    }

    public abstract boolean isMultiple();

    public void clearOptions() {
        Iterator optionIter = this.m_container.getComponents().iterator();
        this.m_container.clearComponents();
        while (optionIter.hasNext()) {
            PersistentComponentFactory componentFactory = (PersistentComponentFactory)optionIter.next();
            componentFactory.delete();
        }
    }

    public Collection getOptions() {
        return this.m_container.getComponents();
    }

    protected List getSelectedOptions() {
        return this.m_container.getSelectedComponents();
    }

    public AttributeMetaDataList getAttributeMetaData() {
        AttributeMetaDataList list = new AttributeMetaDataList();
        list.add(new AttributeMetaData("parameterName", "HTML parameter name", true));
        return list;
    }

    protected void addDataToComponent(Component component) {
        OptionGroup optionGroup = (OptionGroup)component;
        Iterator optionIter = this.getOptions().iterator();
        while (optionIter.hasNext()) {
            PersistentOption optionFactory = (PersistentOption)optionIter.next();
            optionGroup.addOption((Option)optionFactory.createComponent());
        }
        Iterator selectedIter = this.getSelectedOptions().iterator();
        while (selectedIter.hasNext()) {
            PersistentOption optionFactory = (PersistentOption)selectedIter.next();
            optionGroup.setOptionSelected((Option)optionFactory.createComponent());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

