/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.actions;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.util.Placeholders;
import com.arsdigita.mail.Mail;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import javax.mail.MessagingException;

public class ConfirmEmailListener
extends PersistentProcessListener {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.actions.ConfirmEmailListener";
    public static final String FROM = "from";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";

    public ConfirmEmailListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ConfirmEmailListener(String typeName) {
        super(typeName);
    }

    public ConfirmEmailListener(ObjectType type) {
        super(type);
    }

    public ConfirmEmailListener(DataObject obj) {
        super(obj);
    }

    public ConfirmEmailListener(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ConfirmEmailListener(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static ConfirmEmailListener create(String name, String description, String from, String subject, String body) {
        ConfirmEmailListener l = new ConfirmEmailListener();
        l.setup(name, description, from, subject, body);
        return l;
    }

    protected void setup(String name, String description, String from, String subject, String body) {
        super.setup(name, description);
        this.set(FROM, from);
        this.set(SUBJECT, subject);
        this.set(BODY, body);
    }

    public boolean isContainerModified() {
        return false;
    }

    public String getFrom() {
        return (String)this.get(FROM);
    }

    public void setFrom(String from) {
        this.set(FROM, from);
    }

    public String getSubject() {
        return (String)this.get(SUBJECT);
    }

    public void setSubject(String subject) {
        this.set(SUBJECT, subject);
    }

    public String getBody() {
        return (String)this.get(BODY);
    }

    public void setBody(String body) {
        this.set(BODY, body);
    }

    public FormProcessListener createProcessListener() {
        return new ConfirmEmailProcessListener(this.getFrom(), this.getSubject(), this.getBody());
    }

    private class ConfirmEmailProcessListener
    implements FormProcessListener {
        String m_from;
        String m_subject;
        String m_body;

        public ConfirmEmailProcessListener(String from, String subject, String body) {
            this.m_from = from;
            this.m_subject = subject;
            this.m_body = body;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            Placeholders p = new Placeholders(e.getPageState(), e.getFormData());
            String from = p.interpolate(this.m_from);
            String subject = p.interpolate(this.m_subject);
            String body = p.interpolate(this.m_body);
            String to = p.interpolate("::user.email::");
            try {
                Mail message = new Mail(to, from, subject, body);
                message.send();
            }
            catch (MessagingException ex) {
                throw new UncheckedWrapperException("cannot send message", ex);
            }
        }
    }
}

