/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.installer;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.BebopObjectType;
import com.arsdigita.formbuilder.MetaObject;
import com.arsdigita.formbuilder.PersistentDataQuery;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import java.util.Iterator;
import java.util.List;

public class Initializer
extends BaseInitializer {
    public static String WIDGET_TYPES = "widgetTypes";
    public static String PROCESS_LISTENER_TYPES = "processListenerTypes";
    public static String DATA_QUERIES = "dataQueries";
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentComponent;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentProcessListener;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentDataQuery;

    public Initializer() throws InitializationException {
        this.m_conf.initParameter(WIDGET_TYPES, "The persistent widget types", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(PROCESS_LISTENER_TYPES, "The persistent process listener types", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(DATA_QUERIES, "The queries for the data driven select box", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    protected void doStartup() {
        List queries;
        List listeners;
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        List widgets = (List)this.m_conf.getParameter(WIDGET_TYPES);
        if (widgets != null) {
            this.loadMetaObjects(widgets, class$com$arsdigita$formbuilder$PersistentComponent == null ? (class$com$arsdigita$formbuilder$PersistentComponent = Initializer.class$("com.arsdigita.formbuilder.PersistentComponent")) : class$com$arsdigita$formbuilder$PersistentComponent);
        }
        if ((listeners = (List)this.m_conf.getParameter(PROCESS_LISTENER_TYPES)) != null) {
            this.loadMetaObjects(listeners, class$com$arsdigita$formbuilder$PersistentProcessListener == null ? (class$com$arsdigita$formbuilder$PersistentProcessListener = Initializer.class$("com.arsdigita.formbuilder.PersistentProcessListener")) : class$com$arsdigita$formbuilder$PersistentProcessListener);
        }
        if ((queries = (List)this.m_conf.getParameter(DATA_QUERIES)) != null) {
            this.loadDataQueries(queries);
        }
        txn.commitTxn();
    }

    protected void doShutdown() {
    }

    public BebopObjectType getObjectType(String name, Class type) {
        BebopObjectType objectType = null;
        try {
            objectType = BebopObjectType.findByClass(name, type);
        }
        catch (DataObjectNotFoundException ex) {
            objectType = BebopObjectType.create(name, type);
            objectType.save();
        }
        return objectType;
    }

    protected void loadMetaObjects(List objects, Class type) throws InitializationException {
        Iterator objects_i = objects.iterator();
        while (objects_i.hasNext()) {
            List object = (List)objects_i.next();
            String appName = (String)object.get(0);
            String prettyName = (String)object.get(1);
            String prettyPlural = (String)object.get(2);
            String className = (String)object.get(3);
            String propertiesForm = (String)object.get(4);
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new InitializationException("cannot find class " + className);
            }
            try {
                Class.forName(propertiesForm);
            }
            catch (ClassNotFoundException ex) {
                throw new InitializationException("cannot find class " + propertiesForm);
            }
            try {
                MetaObject mo = MetaObject.findByClassName(this.getObjectType(appName, type), className);
                mo.setPrettyName(prettyName);
                mo.setPrettyPlural(prettyPlural);
                mo.setWidgetClassName(className);
                mo.setPropertiesFormName(propertiesForm);
                mo.save();
            }
            catch (DataObjectNotFoundException ex) {
                MetaObject mo = MetaObject.create(this.getObjectType(appName, type), prettyName, prettyPlural, className, propertiesForm);
                mo.save();
            }
        }
    }

    protected void loadDataQueries(List objects) throws InitializationException {
        Iterator objects_i = objects.iterator();
        while (objects_i.hasNext()) {
            List object = (List)objects_i.next();
            String appName = (String)object.get(0);
            String name = (String)object.get(1);
            String description = (String)object.get(2);
            try {
                PersistentDataQuery q = PersistentDataQuery.findByName(this.getObjectType(appName, class$com$arsdigita$formbuilder$PersistentDataQuery == null ? Initializer.class$("com.arsdigita.formbuilder.PersistentDataQuery") : class$com$arsdigita$formbuilder$PersistentDataQuery), name);
                q.setName(name);
                q.setDescription(description);
                q.save();
            }
            catch (DataObjectNotFoundException ex) {
                PersistentDataQuery q = PersistentDataQuery.create(this.getObjectType(appName, class$com$arsdigita$formbuilder$PersistentDataQuery == null ? Initializer.class$("com.arsdigita.formbuilder.PersistentDataQuery") : class$com$arsdigita$formbuilder$PersistentDataQuery), description, name);
                q.save();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

