/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.BaseLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.WidgetLabel;
import com.arsdigita.formbuilder.ui.BaseEditAddObserver;
import com.arsdigita.formbuilder.ui.ControlProperties;
import com.arsdigita.formbuilder.ui.FormCompletionListener;
import com.arsdigita.formbuilder.ui.MoveControl;
import com.arsdigita.formbuilder.ui.NewControl;
import com.arsdigita.formbuilder.ui.NewSection;
import com.arsdigita.formbuilder.ui.PlaceholdersInitListener;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import javax.servlet.ServletException;

public class ControlEditor
extends SimpleContainer {
    private ParameterSingleSelectionModel m_control;
    private SingleSelectionModel m_form;
    private NewControl m_new_control;
    private NewSection m_new_section;
    private BoxPanel m_view_form;
    private ControlProperties m_control_props;
    private MoveControl m_move_control;

    public ControlEditor(String app, SingleSelectionModel form) {
        this(app, form, false);
    }

    public ControlEditor(String app, SingleSelectionModel form, boolean wantFormSection) {
        this.m_form = form;
        this.m_new_control = new NewControl(app);
        this.m_new_section = new NewSection(form);
        String helpURL = FormBuilderUtil.getConfig().getControlsHelpLink();
        if (helpURL != null) {
            this.add(new Link((Component)new Label(GlobalizationUtil.globalize("formbuilder.ui.help")), helpURL));
            this.add(new Label(""));
        }
        this.m_control = new ParameterSingleSelectionModel(new BigDecimalParameter("control"));
        this.m_view_form = new BoxPanel(2);
        this.addEditableComponent(this.m_view_form, this.m_new_control);
        if (wantFormSection) {
            this.addEditableComponent(this.m_view_form, this.m_new_section);
        }
        this.m_view_form.add(new FormItemControlsForm("view_form"));
        this.m_control_props = new ControlProperties(this.m_form, this.m_new_control.getSelection(), this.m_control, app);
        this.m_move_control = new MoveControl(this.m_form, this.m_control);
        this.m_new_section.addProcessListener(new NewSectionProcessListener());
        this.m_new_control.addProcessListener(new NewControlProcessListener());
        this.m_control_props.addCompletionListener(new ControlPropsCompletionListener());
        this.m_move_control.addActionListener(new MoveControlActionListener());
        this.add(this.m_view_form);
        this.addEditableComponent(this, this.m_control_props);
        this.addEditableComponent(this, this.m_move_control);
    }

    protected void addEditableComponent(Container container, Component child) {
        container.add(child);
    }

    protected PersistentComponentFactory getFormSection(PageState state, BigDecimal sectionID) {
        PersistentComponentFactory section = null;
        try {
            section = (PersistentComponentFactory)((Object)DomainObjectFactory.newInstance(new OID("com.arsdigita.formbuilder.Component", (Object)sectionID)));
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot instantiate section", ex);
        }
        return section;
    }

    public void setFormSectionModelBuilder(PrintListener l) {
        this.m_new_section.setFormSectionModelBuilder(l);
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        String name = state.getControlEventName();
        String value = state.getControlEventValue();
        if (name.equals("edit")) {
            this.m_control.setSelectedKey(state, new BigDecimal(value));
            this.m_view_form.setVisible(state, false);
            this.m_control_props.setVisible(state, true);
        } else if (name.equals("delete")) {
            this.m_control.setSelectedKey(state, new BigDecimal(value));
            BigDecimal form_id = (BigDecimal)this.m_form.getSelectedKey(state);
            BigDecimal control_id = (BigDecimal)this.m_control.getSelectedKey(state);
            PersistentFormSection fs = (PersistentFormSection)FormBuilderUtil.instantiateObject(form_id);
            PersistentComponent c = (PersistentComponent)FormBuilderUtil.instantiateObject(control_id);
            fs.removeComponent(c);
            try {
                PersistentWidget w = (PersistentWidget)c;
                WidgetLabel label = WidgetLabel.findByWidget(w);
                fs.removeComponent(label);
                label.delete();
            }
            catch (ClassCastException ex) {
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (!(c instanceof PersistentFormSection)) {
                c.delete();
            }
            this.m_control.setSelectedKey(state, null);
        } else if (name.equals("move")) {
            this.m_control.setSelectedKey(state, new BigDecimal(value));
            this.m_view_form.setVisible(state, false);
            this.m_move_control.setVisible(state, true);
        }
    }

    protected SingleSelectionModel getFormModel() {
        return this.m_form;
    }

    public void register(Page page) {
        super.register(page);
        page.addComponentStateParam(this, this.m_control.getStateParameter());
        page.setVisibleDefault(this.m_view_form, true);
        page.setVisibleDefault(this.m_control_props, false);
        page.setVisibleDefault(this.m_move_control, false);
    }

    protected boolean addItemEditObserver(PageState state) {
        return true;
    }

    private class FormItemControlsForm
    extends MetaForm {
        public FormItemControlsForm(String name) {
            super(name);
        }

        public Form buildForm(PageState state) {
            BigDecimal form_id = (BigDecimal)ControlEditor.this.m_form.getSelectedKey(state);
            PersistentFormSection section = (PersistentFormSection)FormBuilderUtil.instantiateObject(form_id);
            if (ControlEditor.this.addItemEditObserver(state)) {
                section.setComponentAddObserver(new ItemEditAddObserver(ControlEditor.this, state));
                section.setFormContainer(new ColumnPanel(3));
            } else {
                section.setFormContainer(new ColumnPanel(2));
            }
            Form f = null;
            if (section instanceof PersistentForm) {
                f = (Form)section.createComponent();
            } else {
                f = new Form("view_form", new ColumnPanel(1));
                f.add((FormSection)section.createComponent());
            }
            f.addInitListener(new PlaceholdersInitListener());
            Traversal t = new Traversal(){

                public void act(Component c) {
                    try {
                        Widget widget = (Widget)c;
                        widget.setDisabled();
                        widget.setReadOnly();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            };
            t.preorder(f);
            return f;
        }

        private class ItemEditAddObserver
        extends BaseEditAddObserver {
            Component m_handler;
            PageState m_state;

            public ItemEditAddObserver(Component handler, PageState state) {
                this.m_handler = handler;
                this.m_state = state;
            }

            protected BaseLink createLink(String dest, PersistentComponentFactory component) {
                return new CallbackLink(this.m_handler, "[" + dest + "]", dest, component.getID().toString());
            }

            private class CallbackLink
            extends ControlLink {
                Component m_handler;
                String m_action;
                String m_component;

                public CallbackLink(Component handler, String label, String action, String component) {
                    super(label);
                    this.m_handler = handler;
                    this.m_action = action;
                    this.m_component = component;
                }

                public void setControlEvent(PageState state) {
                    state.setControlEvent(this.m_handler, this.m_action, this.m_component);
                }
            }
        }
    }

    private class MoveControlActionListener
    implements ActionListener {
        private MoveControlActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ControlEditor.this.m_control.setSelectedKey(e.getPageState(), null);
            ControlEditor.this.m_view_form.setVisible(e.getPageState(), true);
            ControlEditor.this.m_move_control.setVisible(e.getPageState(), false);
        }
    }

    private class ControlPropsCompletionListener
    implements FormCompletionListener {
        private ControlPropsCompletionListener() {
        }

        public void complete(FormSectionEvent e) throws FormProcessException {
            ControlEditor.this.m_control.setSelectedKey(e.getPageState(), null);
            ControlEditor.this.m_view_form.setVisible(e.getPageState(), true);
            ControlEditor.this.m_control_props.setVisible(e.getPageState(), false);
        }
    }

    private class NewControlProcessListener
    implements FormProcessListener {
        private NewControlProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            ControlEditor.this.m_control.setSelectedKey(e.getPageState(), null);
            ControlEditor.this.m_view_form.setVisible(e.getPageState(), false);
            ControlEditor.this.m_control_props.setVisible(e.getPageState(), true);
        }
    }

    private class NewSectionProcessListener
    implements FormProcessListener {
        private NewSectionProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            BigDecimal form_id = (BigDecimal)ControlEditor.this.m_form.getSelectedKey(state);
            PersistentFormSection form = (PersistentFormSection)FormBuilderUtil.instantiateObject(form_id);
            BigDecimal id = ControlEditor.this.m_new_section.getSelectedSection(state);
            PersistentComponentFactory section = ControlEditor.this.getFormSection(state, id);
            form.addComponent(section);
        }
    }
}

