/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.util.Attributes;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.formbuilder.DataDrivenSelect;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentDataQuery;
import com.arsdigita.formbuilder.PersistentDate;
import com.arsdigita.formbuilder.util.AttributeHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.text.DateFormatSymbols;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FormBuilderXMLRenderer
extends DomainObjectXMLRenderer {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$ui$FormBuilderXMLRenderer == null ? (class$com$arsdigita$formbuilder$ui$FormBuilderXMLRenderer = FormBuilderXMLRenderer.class$("com.arsdigita.formbuilder.ui.FormBuilderXMLRenderer")) : class$com$arsdigita$formbuilder$ui$FormBuilderXMLRenderer));
    static /* synthetic */ Class class$com$arsdigita$formbuilder$ui$FormBuilderXMLRenderer;

    public FormBuilderXMLRenderer(Element root) {
        super(root);
    }

    protected void endAssociation(DomainObject obj, String path, Property property) {
        if (obj instanceof PersistentDate) {
            this.handlePersistentDate((PersistentDate)obj, path, property);
        } else if (obj instanceof DataDrivenSelect) {
            this.handleDataDrivenSelect((DataDrivenSelect)obj, path, property);
        }
        super.endAssociation(obj, path, property);
    }

    protected void handleAttribute(DomainObject obj, String path, Property property) {
        if (obj instanceof PersistentComponent) {
            String name = property.getName();
            if (obj instanceof PersistentDate && "defaultValue".equals(name)) {
                Date defaultDate = (Date)PersistentDate.deserializeDefaultValue((String)DomainServiceInterfaceExposer.get(obj, name));
                if (defaultDate != null) {
                    Element element = this.newElement(this.getCurrentElement(), "defaultValue");
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(defaultDate);
                    String value = Integer.toString(calendar.get(5));
                    this.addElement(element, "day", value);
                    value = Integer.toString(calendar.get(2));
                    this.addElement(element, "month", value);
                    value = Integer.toString(calendar.get(1));
                    this.addElement(element, "year", value);
                }
            } else if ("attributeString".equals(name)) {
                Attributes attributes;
                Collection keysCollection;
                Object value = DomainServiceInterfaceExposer.get(obj, name);
                if (value != null && (keysCollection = (attributes = new AttributeHelper().getAttributesMap(value.toString())).getAttributeKeys()) != null) {
                    Iterator keys = keysCollection.iterator();
                    Element currentElement = this.getCurrentElement();
                    while (keys.hasNext()) {
                        String keyName = (String)keys.next();
                        String keyValue = attributes.getAttribute(keyName);
                        this.addElement(currentElement, keyName, keyValue);
                    }
                }
            } else {
                super.handleAttribute(obj, path, property);
            }
        } else {
            super.handleAttribute(obj, path, property);
        }
    }

    private Element addElement(Element currentElement, String name, String value) {
        if (this.isWrappingAttributes()) {
            Element element = this.newElement(currentElement, name);
            element.setText(value);
            return element;
        }
        currentElement.addAttribute(name, value);
        return currentElement;
    }

    private void handlePersistentDate(PersistentDate date, String path, Property property) {
        Integer startYear = date.getStartYear();
        Integer endYear = date.getEndYear();
        Element currentElement = this.getCurrentElement();
        Element monthElement = this.newElement(currentElement, "monthList");
        Element yearElement = this.newElement(currentElement, "yearList");
        int defaultMonth = -1;
        int defaultYear = -1;
        Date defaultDate = (Date)date.getDefaultValue();
        if (defaultDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(defaultDate);
            defaultMonth = calendar.get(2);
            defaultYear = calendar.get(1);
        }
        Locale locale = Kernel.getContext().getLocale();
        DateFormatSymbols dfs = null;
        dfs = locale != null ? new DateFormatSymbols(locale) : new DateFormatSymbols();
        String[] months = dfs.getMonths();
        for (int i = 0; i < months.length; ++i) {
            if (months[i].length() <= 0) continue;
            Element month = this.newElement(monthElement, "month");
            month.setText(months[i]);
            month.addAttribute("value", Integer.toString(i));
            if (defaultMonth != i) continue;
            month.addAttribute("selected", "selected");
        }
        int startYearInt = -1;
        int endYearInt = -1;
        startYearInt = startYear != null ? startYear : GregorianCalendar.getInstance().get(1) - 5;
        endYearInt = endYear != null ? endYear : startYearInt + 10;
        for (int i = startYearInt; i <= endYearInt; ++i) {
            Element year = this.newElement(yearElement, "year");
            year.setText(Integer.toString(i));
            year.addAttribute("value", Integer.toString(i));
            if (defaultYear != i) continue;
            year.addAttribute("selected", "selected");
        }
    }

    private void handleDataDrivenSelect(DataDrivenSelect obj, String path, Property property) {
        Element dataSelect = this.newElement(this.getCurrentElement(), "selectOptions");
        if (obj.isMultiple()) {
            dataSelect.addAttribute("multiple", "true");
        }
        PersistentDataQuery query = null;
        try {
            query = obj.getQuery();
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException(ex);
        }
        DataQuery items = SessionManager.getSession().retrieveQuery(query.getName());
        while (items.next()) {
            String id = items.get("id").toString();
            String label = items.get("label").toString();
            Element optionElement = this.newElement(dataSelect, "option");
            optionElement.addAttribute("id", id);
            optionElement.addAttribute("label", label);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

