/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.MetaObject;
import com.arsdigita.formbuilder.MetaObjectCollection;
import com.arsdigita.formbuilder.ui.FormCompletionListener;
import com.arsdigita.formbuilder.ui.PropertiesEditor;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public abstract class MetaObjectProperties
extends SimpleContainer {
    private HashMap m_widget_map;
    private HashMap m_id_map;
    private String m_app;
    private Class m_type;

    public MetaObjectProperties(String app, Class type) {
        this.m_type = type;
        this.m_app = app;
        this.m_widget_map = new HashMap();
        this.m_id_map = new HashMap();
    }

    protected void addForms() {
        MetaObjectCollection forms = null;
        try {
            forms = MetaObject.getWidgets(this.m_app, this.m_type);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot find object type", ex);
        }
        while (forms.next()) {
            MetaObject obj = forms.getMetaObject();
            PropertiesEditor f = this.getPropertiesEditor(obj);
            f.setApplication(this.m_app);
            this.m_widget_map.put(obj.getWidgetClassName(), f);
            this.m_id_map.put(obj.getID(), f);
            this.add(f);
        }
    }

    public void register(Page p) {
        super.register(p);
        Iterator forms = this.m_widget_map.values().iterator();
        while (forms.hasNext()) {
            PropertiesEditor f = (PropertiesEditor)forms.next();
            p.setVisibleDefault(f, false);
        }
    }

    public void setFormVisible(PageState state, String widget) {
        Iterator forms = this.m_widget_map.keySet().iterator();
        while (forms.hasNext()) {
            String className = (String)forms.next();
            PropertiesEditor f = (PropertiesEditor)this.m_widget_map.get(className);
            f.setVisible(state, className.equals(widget));
        }
    }

    public void setFormVisible(PageState state, BigDecimal widget) {
        Iterator forms = this.m_id_map.keySet().iterator();
        while (forms.hasNext()) {
            BigDecimal id = (BigDecimal)forms.next();
            PropertiesEditor f = (PropertiesEditor)this.m_id_map.get(id);
            f.setVisible(state, id.equals(widget));
        }
    }

    public void addCompletionListener(FormCompletionListener l) {
        Iterator forms = this.m_widget_map.values().iterator();
        while (forms.hasNext()) {
            PropertiesEditor f = (PropertiesEditor)forms.next();
            MetaObjectListener ml = new MetaObjectListener(l, this);
            f.addProcessListener(ml);
            f.addSubmissionListener(ml);
        }
    }

    protected abstract PropertiesEditor getPropertiesEditor(MetaObject var1);

    private class MetaObjectListener
    implements FormSubmissionListener,
    FormProcessListener {
        FormCompletionListener m_l;
        Object m_source;

        public MetaObjectListener(FormCompletionListener l, Object source) {
            this.m_l = l;
            this.m_source = source;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PropertiesEditor f = (PropertiesEditor)e.getSource();
            if (f.isComplete(e.getPageState())) {
                this.m_l.complete(new FormSectionEvent(this.m_source, e.getPageState(), e.getFormData()));
            }
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            PropertiesEditor f = (PropertiesEditor)e.getSource();
            if (f.isCancelled(e.getPageState())) {
                this.m_l.complete(new FormSectionEvent(this.m_source, e.getPageState(), e.getFormData()));
            }
        }
    }
}

