/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Select;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.BooleanParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.BebopObjectType;
import com.arsdigita.formbuilder.DataDrivenSelect;
import com.arsdigita.formbuilder.PersistentDataQuery;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.editors.WidgetLabelForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.TooManyListenersException;

public class DataDrivenSelectForm
extends WidgetLabelForm {
    private SingleSelect m_query;
    private RadioGroup m_multiple;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$PersistentDataQuery;

    public DataDrivenSelectForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_query = new SingleSelect(new BigDecimalParameter("query"));
        this.m_query.addValidationListener(new NotNullValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.query")), 4);
        section.add(this.m_query);
        try {
            this.m_query.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    DataDrivenSelectForm.this.loadComponents((Select)e.getTarget(), e.getPageState());
                }
            });
        }
        catch (TooManyListenersException ex) {
            throw new UncheckedWrapperException("this should not happen", ex);
        }
        this.m_multiple = new RadioGroup(new BooleanParameter("multiple"));
        this.m_multiple.addValidationListener(new NotNullValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.multiselect")), 4);
        section.add(this.m_multiple);
        this.m_multiple.addOption(new Option("false", "No"));
        this.m_multiple.addOption(new Option("true", "Yes"));
    }

    protected PersistentWidget getWidget() {
        return new DataDrivenSelect();
    }

    protected PersistentWidget getWidget(BigDecimal id) throws DataObjectNotFoundException {
        return new DataDrivenSelect(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.initWidgets(e, w);
        DataDrivenSelect query = (DataDrivenSelect)w;
        if (query == null) {
            // empty if block
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.processWidgets(e, w);
        DataDrivenSelect widget = (DataDrivenSelect)w;
        FormData data = e.getFormData();
        BigDecimal query = (BigDecimal)data.get("query");
        Boolean multiple = (Boolean)data.get("multiple");
        widget.setMultiple(multiple);
        widget.setQueryID(query);
    }

    protected void loadComponents(Select select, PageState state) {
        try {
            BebopObjectType type = BebopObjectType.findByClass(this.getApplication(), class$com$arsdigita$formbuilder$PersistentDataQuery == null ? (class$com$arsdigita$formbuilder$PersistentDataQuery = DataDrivenSelectForm.class$("com.arsdigita.formbuilder.PersistentDataQuery")) : class$com$arsdigita$formbuilder$PersistentDataQuery);
            Iterator objects = PersistentDataQuery.getQueries(type).iterator();
            while (objects.hasNext()) {
                PersistentDataQuery control = (PersistentDataQuery)objects.next();
                select.addOption(new Option(control.getID().toString(), control.getDescription()));
            }
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
            throw new UncheckedWrapperException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

