/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentOption;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Iterator;

public abstract class OptionEditor
extends FormSection {
    SingleSelectionModel m_control;
    Table m_table;
    TextField m_value;
    TextField m_label;
    SaveCancelSection m_buttons;
    private RequestLocal m_optionGroup = new RequestLocal(){

        public Object initialValue(PageState pageState) {
            BigDecimal control = (BigDecimal)OptionEditor.this.m_control.getSelectedKey(pageState);
            PersistentOptionGroup group = null;
            try {
                group = OptionEditor.this.getOptionGroup(control);
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException("cannot find option group", ex);
            }
            return group;
        }
    };

    public OptionEditor(SingleSelectionModel control) {
        super(new BoxPanel(2));
        this.m_control = control;
        Object[] tableHeaders = null;
        tableHeaders = this.showOptionValue() ? new String[]{"Value", "Option Label", "", ""} : new String[]{"Option Label", "", ""};
        this.m_table = new Table((TableModelBuilder)new OptionTableModelBuilder(), tableHeaders);
        this.m_table.setDefaultCellRenderer(new TableCellRenderer(){

            public Component getComponent(Table table, PageState state, Object value, boolean param4, Object key, int row, int column) {
                PersistentOption option = (PersistentOption)value;
                int columnShift = 0;
                if (!OptionEditor.this.showOptionValue()) {
                    columnShift = -1;
                }
                if (column == 0 + columnShift) {
                    return new Label(option.getParameterValue());
                }
                if (column == 1 + columnShift) {
                    return new Label(option.getLabel());
                }
                if (column == 2 + columnShift) {
                    return new ControlLink((String)GlobalizationUtil.globalize("formbuilder.ui.editors.edit").localize());
                }
                if (column == 3 + columnShift) {
                    return new ControlLink((String)GlobalizationUtil.globalize("formbuilder.ui.editors.delete").localize());
                }
                return null;
            }
        });
        this.m_table.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent e) {
                PageState state = e.getPageState();
                Integer column = e.getColumn();
                String key = (String)e.getRowKey();
                BigDecimal id = new BigDecimal(key);
                PersistentOption option = null;
                try {
                    option = new PersistentOption(id);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new UncheckedWrapperException("cannot find option", ex);
                }
                if (column == 2) {
                    if (OptionEditor.this.showOptionValue()) {
                        OptionEditor.this.m_value.setValue(state, option.getParameterValue());
                    }
                    OptionEditor.this.m_label.setValue(state, option.getLabel());
                } else if (column == 3) {
                    PersistentOptionGroup group = OptionEditor.this.fetchOptionGroup(state);
                    group.removeOption(option);
                    option.delete();
                    OptionEditor.this.m_table.getRowSelectionModel().clearSelection(state);
                }
            }

            public void headSelected(TableActionEvent e) {
            }
        });
        this.add(this.m_table);
        if (this.showOptionValue()) {
            this.m_value = new TextField(new StringParameter("opt_value"));
        }
        this.m_label = new TextField(new StringParameter("opt_label"));
        this.m_buttons = new SaveCancelSection();
        this.m_buttons.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (OptionEditor.this.m_buttons.getSaveButton().isSelected(state)) {
                    String key = (String)OptionEditor.this.m_table.getRowSelectionModel().getSelectedKey(state);
                    PersistentOption option = null;
                    if (key == null) {
                        option = new PersistentOption();
                    } else {
                        BigDecimal id = new BigDecimal(key);
                        try {
                            option = new PersistentOption(id);
                        }
                        catch (DataObjectNotFoundException ex) {
                            throw new FormProcessException("cannot find option", ex);
                        }
                    }
                    FormData data = e.getFormData();
                    option.setParameterValue(OptionEditor.this.getOptionName(data, option));
                    option.setLabel((String)data.get("opt_label"));
                    option.save();
                    if (key == null) {
                        PersistentOptionGroup group = OptionEditor.this.fetchOptionGroup(state);
                        group.addOption(option);
                    }
                }
                if (OptionEditor.this.showOptionValue()) {
                    OptionEditor.this.m_value.setValue(state, "");
                }
                OptionEditor.this.m_label.setValue(state, "");
                OptionEditor.this.m_table.getRowSelectionModel().clearSelection(state);
            }
        });
        ColumnPanel editor = new ColumnPanel(2);
        editor.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.add_option")), 64);
        if (this.showOptionValue()) {
            editor.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.value")));
            editor.add(this.m_value);
        }
        editor.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.option_label")));
        editor.add(this.m_label);
        editor.add(this.m_buttons);
        editor.setConstraint(this.m_buttons, 64);
        this.add(editor);
    }

    protected boolean showOptionValue() {
        return true;
    }

    protected String getOptionName(FormData formData, PersistentOption option) {
        return (String)formData.get("opt_value");
    }

    protected PersistentOptionGroup fetchOptionGroup(PageState pageState) {
        return (PersistentOptionGroup)this.m_optionGroup.get(pageState);
    }

    protected abstract PersistentOptionGroup getOptionGroup(BigDecimal var1) throws DataObjectNotFoundException;

    private class OptionTableModelBuilder
    extends AbstractTableModelBuilder {
        private OptionTableModelBuilder() {
        }

        public TableModel makeModel(Table table, PageState state) {
            PersistentOptionGroup group = OptionEditor.this.fetchOptionGroup(state);
            return new OptionTableModel(group.getOptions().iterator());
        }

        private class OptionTableModel
        implements TableModel {
            Iterator m_options;
            PersistentOption m_option;

            public OptionTableModel(Iterator options) {
                this.m_options = options;
                this.m_option = null;
            }

            public Object getKeyAt(int param1) {
                return this.m_option.getID();
            }

            public Object getElementAt(int param1) {
                return this.m_option;
            }

            public boolean nextRow() {
                if (this.m_options.hasNext()) {
                    this.m_option = (PersistentOption)this.m_options.next();
                    return true;
                }
                return false;
            }

            public int getColumnCount() {
                return 2;
            }
        }
    }
}

