/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentPassword;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.editors.WidgetLabelForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public class PasswordForm
extends WidgetLabelForm {
    private TextField m_width;
    private TextField m_length;
    private TextField m_value;

    public PasswordForm(String name, SingleSelectionModel form, SingleSelectionModel control) {
        super(name, form, control);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_length = new TextField(new IntegerParameter("length"));
        this.m_length.addValidationListener(new NotNullValidationListener());
        this.m_length.setSize(5);
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.max_length")), 4);
        section.add(this.m_length);
        this.m_width = new TextField(new IntegerParameter("width"));
        this.m_width.addValidationListener(new NotNullValidationListener());
        this.m_width.addValidationListener(new NumberInRangeValidationListener(1L, 50L));
        this.m_width.setSize(5);
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.width")), 4);
        section.add(this.m_width);
        this.m_value = new TextField(new StringParameter("value"));
        this.m_value.setSize(50);
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.value")), 4);
        section.add(this.m_value);
    }

    protected PersistentWidget getWidget() {
        return new PersistentPassword();
    }

    protected PersistentWidget getWidget(BigDecimal id) throws DataObjectNotFoundException {
        return new PersistentPassword(id);
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.initWidgets(e, w);
        PersistentPassword widget = (PersistentPassword)w;
        PageState state = e.getPageState();
        if (widget == null) {
            this.m_width.setValue(state, "");
            this.m_length.setValue(state, "");
            this.m_value.setValue(state, "");
        } else {
            this.m_width.setValue(state, new Integer(widget.getSize()));
            this.m_length.setValue(state, new Integer(widget.getMaxLength()));
            this.m_value.setValue(state, widget.getDefaultValue());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget w) throws FormProcessException {
        super.processWidgets(e, w);
        PersistentPassword widget = (PersistentPassword)w;
        FormData data = e.getFormData();
        Integer length = (Integer)data.get("length");
        Integer width = (Integer)data.get("width");
        String value = (String)data.get("value");
        widget.setMaxLength(length);
        widget.setSize(width);
        widget.setDefaultValue(value);
    }
}

