/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLTokenValidationListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.ui.PropertiesForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;

public abstract class ProcessListenerForm
extends PropertiesForm {
    private SingleSelectionModel m_form;
    private SingleSelectionModel m_action;
    private TextField m_name;
    private TextField m_description;

    public ProcessListenerForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name);
        this.m_form = form;
        this.m_action = action;
        this.addInitListener(new ProcessListenerFormInitListener());
        this.addProcessListener(new ProcessListenerFormProcessListener());
    }

    protected abstract PersistentProcessListener getProcessListener();

    protected abstract PersistentProcessListener getProcessListener(BigDecimal var1) throws DataObjectNotFoundException;

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_name = new TextField(new StringParameter("name"));
        this.m_name.setSize(50);
        this.m_name.addValidationListener(new NotNullValidationListener());
        this.m_name.addValidationListener(new StringInRangeValidationListener(1, 30));
        this.m_name.addValidationListener(new URLTokenValidationListener());
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.name")), 4);
        section.add(this.m_name);
        this.m_description = new TextField(new StringParameter("description"));
        this.m_description.setSize(50);
        this.m_description.addValidationListener(new NotNullValidationListener());
        this.m_description.addValidationListener(new StringInRangeValidationListener(1, 70));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.description")), 4);
        section.add(this.m_description);
    }

    protected void initWidgets(FormSectionEvent e, PersistentProcessListener l) throws FormProcessException {
        PageState state = e.getPageState();
        if (l == null) {
            this.m_name.setValue(state, "");
            this.m_description.setValue(state, "");
        } else {
            this.m_name.setValue(state, l.getName());
            this.m_description.setValue(state, l.getDescription());
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentProcessListener l) throws FormProcessException {
        FormData data = e.getFormData();
        String name = (String)data.get("name");
        String description = (String)data.get("description");
        l.setName(name);
        l.setDescription(description);
    }

    protected void addToForm(FormSectionEvent e, PersistentProcessListener l) throws FormProcessException {
        BigDecimal form_id = (BigDecimal)this.m_form.getSelectedKey(e.getPageState());
        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection(form_id);
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
            throw new FormProcessException("cannot find form", ex);
        }
        form.addProcessListener(l);
        form.save();
    }

    private class ProcessListenerFormProcessListener
    implements FormProcessListener {
        private ProcessListenerFormProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (ProcessListenerForm.this.isCancelled(state)) {
                return;
            }
            BigDecimal action = (BigDecimal)ProcessListenerForm.this.m_action.getSelectedKey(state);
            PersistentProcessListener widget = null;
            if (action == null) {
                widget = ProcessListenerForm.this.getProcessListener();
                ProcessListenerForm.this.m_action.setSelectedKey(state, widget.setID());
            } else {
                try {
                    widget = ProcessListenerForm.this.getProcessListener(action);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new FormProcessException("cannot find persistent process listener " + action, ex);
                }
            }
            ProcessListenerForm.this.processWidgets(e, widget);
            widget.save();
            if (action == null) {
                ProcessListenerForm.this.addToForm(e, widget);
            }
        }
    }

    private class ProcessListenerFormInitListener
    implements FormInitListener {
        private ProcessListenerFormInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            BigDecimal action = (BigDecimal)ProcessListenerForm.this.m_action.getSelectedKey(state);
            if (action == null) {
                ProcessListenerForm.this.initWidgets(e, null);
            } else {
                PersistentProcessListener widget = null;
                try {
                    widget = ProcessListenerForm.this.getProcessListener(action);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new FormProcessException("cannot find persistent process listener " + action, ex);
                }
                ProcessListenerForm.this.initWidgets(e, widget);
            }
        }
    }
}

