/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.util;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.db.Sequences;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class Placeholders {
    private HashMap m_vars;

    public Placeholders(PageState state) {
        User user = (User)Kernel.getContext().getParty();
        this.m_vars = new HashMap();
        if (user != null) {
            this.setUserVars(user);
        }
        this.setSystemVars();
    }

    public Placeholders(PageState state, FormData data) {
        User user = (User)Kernel.getContext().getParty();
        this.m_vars = new HashMap();
        if (user != null) {
            this.setUserVars(user);
        }
        this.setFormVars(data);
        this.setSystemVars();
    }

    public String interpolate(String text) {
        return StringUtils.interpolate(text, this.m_vars);
    }

    public void setVariable(String key, String value) {
        this.m_vars.put(key, value);
    }

    protected void setUserVars(User user) {
        PersonName name = user.getPersonName();
        this.m_vars.put("user.givenname", name.getGivenName());
        this.m_vars.put("user.familyname", name.getFamilyName());
        this.m_vars.put("user.screenname", user.getScreenName());
        this.m_vars.put("user.email", user.getPrimaryEmail().getEmailAddress());
    }

    protected void setFormVars(FormData data) {
        Iterator params = data.getParameters().iterator();
        while (params.hasNext()) {
            ParameterData param = (ParameterData)params.next();
            Object value = param.getValue();
            this.m_vars.put("form." + param.getName(), value == null ? "(null)" : value.toString());
        }
    }

    protected void setSystemVars() {
        this.m_vars.put("system.uniqueid", new UniqueIDGenerator());
    }

    private class UniqueIDGenerator
    implements StringUtils.PlaceholderValueGenerator {
        private UniqueIDGenerator() {
        }

        public String generate(String key) {
            BigDecimal id;
            try {
                id = Sequences.getNextValue("forms_unique_id_seq");
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
            return id.toString();
        }
    }
}

