/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.globalization.AcceptField;
import com.arsdigita.globalization.AcceptLanguage;
import com.arsdigita.globalization.AcceptLanguageHeader;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.LocaleNegotiator;
import com.arsdigita.globalization.LocaleProvider;
import com.arsdigita.globalization.SystemLocaleProvider;
import java.util.Locale;
import java.util.ResourceBundle;

public class ClientLocaleProvider
implements LocaleProvider {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/ClientLocaleProvider.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_targetBundle = "";
    private String m_acceptLanguages = "";

    public Locale getLocale() {
        ResourceBundle b = null;
        Locale l = null;
        if (this.m_acceptLanguages.length() > 0) {
            AcceptField[] af = new AcceptLanguageHeader(this.m_acceptLanguages).getAcceptFields();
            for (int i = 0; i < af.length; ++i) {
                l = ((AcceptLanguage)af[i]).getLocale();
                SystemLocaleProvider slp = (SystemLocaleProvider)LocaleNegotiator.getSystemLocaleProvider();
                Locale defaultLocale = null;
                if (slp != null) {
                    defaultLocale = slp.getLocale();
                }
                if (defaultLocale == null) {
                    defaultLocale = Locale.getDefault();
                }
                if ((b = Globalization.getBundleNoFallback(this.m_targetBundle, l, defaultLocale)) != null) break;
            }
            if (b == null) {
                l = ((AcceptLanguage)af[0]).getLocale();
            }
        }
        return l;
    }

    public void setTargetBundle(String targetBundle) {
        this.m_targetBundle = targetBundle != null ? targetBundle : "";
    }

    public void setAcceptLanguages(String acceptLanguages) {
        this.m_acceptLanguages = acceptLanguages != null ? acceptLanguages : "";
    }
}

