/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.initializer;

import com.arsdigita.initializer.InitializationException;
import com.arsdigita.initializer.Script;
import com.arsdigita.util.ResourceManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Set;

public class Startup {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/initializer/Startup.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String WEB_APP_ROOT = "webAppRoot";
    public static final String SCRIPT_NAME = "scriptName";
    private String m_webAppRoot;
    private String m_scriptName;
    private String m_lastInitializer;
    private Script m_ini;

    public Startup(String webAppRoot, String scriptName) {
        this.m_webAppRoot = webAppRoot;
        this.m_scriptName = scriptName;
    }

    public Startup() throws InitializationException {
        this(Startup.getProperty(WEB_APP_ROOT), Startup.getProperty(SCRIPT_NAME));
    }

    public void setLastInitializer(String lastInitializer) {
        this.m_lastInitializer = lastInitializer;
    }

    public Set init() throws InitializationException {
        FileReader r;
        ResourceManager rm = ResourceManager.getInstance();
        rm.setWebappRoot(new File(this.m_webAppRoot));
        try {
            r = new FileReader(this.m_scriptName);
        }
        catch (FileNotFoundException e) {
            throw new InitializationException("Couldn't find " + this.m_scriptName);
        }
        Set initializersRun = null;
        try {
            if (this.m_lastInitializer == null) {
                this.m_ini = new Script(r);
                initializersRun = this.m_ini.startup();
            } else {
                this.m_ini = new Script((Reader)r, this.m_lastInitializer);
                initializersRun = this.m_ini.startup(this.m_lastInitializer);
            }
        }
        catch (InitializationException e) {
            e.printStackTrace(System.err);
            throw new InitializationException("Error loading init script: " + e.getMessage());
        }
        return initializersRun;
    }

    public void destroy() {
        this.m_ini.shutdown();
    }

    private static String getProperty(String propertyName) throws InitializationException {
        String property = System.getProperty(propertyName);
        if (property == null || property.trim().length() == 0) {
            throw new InitializationException("The " + propertyName + " system property could not be " + "found or was empty");
        }
        return property;
    }
}

