/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.installer;

import com.arsdigita.db.DbHelper;
import com.arsdigita.installer.SQLLoader;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class LoadSQLPlusScript {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/installer/LoadSQLPlusScript.java#17 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$installer$LoadSQLPlusScript == null ? (class$com$arsdigita$installer$LoadSQLPlusScript = LoadSQLPlusScript.class$("com.arsdigita.installer.LoadSQLPlusScript")) : class$com$arsdigita$installer$LoadSQLPlusScript));
    private Connection m_con;
    static /* synthetic */ Class class$com$arsdigita$installer$LoadSQLPlusScript;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        if (args.length != 4) {
            s_log.error((Object)"Usage: LoadSQLPlusScript <JDBC_URL> <username> <password> <script_filename>");
            System.exit(1);
        }
        String jdbcUrl = args[0];
        String dbUsername = args[1];
        String dbPassword = args[2];
        String scriptFilename = args[3];
        LoadSQLPlusScript loader = new LoadSQLPlusScript();
        loader.setConnection(jdbcUrl, dbUsername, dbPassword);
        loader.loadSQLPlusScript(scriptFilename);
    }

    public void setConnection(Connection connection) {
        this.m_con = connection;
    }

    public void setConnection(String jdbcUrl, String dbUsername, String dbPassword) {
        try {
            int db = DbHelper.getDatabaseFromURL(jdbcUrl);
            switch (db) {
                case 2: {
                    Class.forName("org.postgresql.Driver");
                    break;
                }
                case 1: {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported database");
                }
            }
            s_log.warn((Object)("Using database " + DbHelper.getDatabaseName(db)));
            this.m_con = DriverManager.getConnection(jdbcUrl, dbUsername, dbPassword);
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public void loadSQLPlusScript(String scriptFilename) {
        this.loadScript(scriptFilename);
    }

    protected void loadScript(String scriptFilename) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Loading: '" + scriptFilename + "'"));
        }
        SQLLoader loader = new SQLLoader(this.m_con){

            protected Reader open(String name) {
                try {
                    return new FileReader(name);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        };
        loader.load(scriptFilename);
        try {
            this.m_con.commit();
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

