/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.kernel.DatabaseTransaction;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

public abstract class BaseInitializer
implements Initializer {
    public void startup() throws InitializationException {
        if (Kernel.getSystemParty() == null) {
            DatabaseTransaction transaction = new DatabaseTransaction();
            transaction.begin();
            this.setupSystemParty();
            transaction.end();
        }
        KernelExcursion rootExcursion = new KernelExcursion(){

            public void excurse() {
                this.setTransaction(new DatabaseTransaction());
                this.setEffectiveParty(Kernel.getSystemParty());
                BaseInitializer.this.doStartup();
            }
        };
        rootExcursion.run();
    }

    public void shutdown() throws InitializationException {
        KernelExcursion rootExcursion = new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                BaseInitializer.this.doShutdown();
            }
        };
        rootExcursion.run();
    }

    public abstract Configuration getConfiguration();

    protected abstract void doStartup();

    protected abstract void doShutdown();

    private void setupSystemParty() {
        Party party = new Party(new OID("com.arsdigita.kernel.Party", (Object)new BigDecimal(-204.0))){

            public String getName() {
                return "ACS System Party";
            }
        };
        party.disconnect();
        Kernel.setSystemParty(party);
    }
}

